/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.TestConnectionAwareRepository;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsBuildWarningsUpdater;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooRepositoryUtils {
    private static final BambooRepositoryUtils INSTANCE = new BambooRepositoryUtils();

    private BambooRepositoryUtils() {
    }

    @NotNull
    public static BambooRepositoryUtils getInstance() {
        return INSTANCE;
    }

    public static boolean isRepositoryTestConnectionAware(@Nullable Repository repository) {
        return repository instanceof TestConnectionAwareRepository;
    }

    public static Optional<VcsBuildWarningsUpdater> getRepositoryBuildWarningUpdater(Long repositoryId, VcsRepositoryManager vcsRepositoryManager, RepositoryDefinitionManager repositoryDefinitionManager, Logger log) {
        VcsRepositoryData repo = repositoryDefinitionManager.getVcsRepositoryData(repositoryId.longValue());
        if (repo == null) {
            log.debug((Object)("Can't send warning data for repo with id=" + repositoryId + " because it was not found in DB"));
            return Optional.empty();
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repo.getPluginKey());
        if (moduleDescriptor == null) {
            log.debug((Object)("Can't send warning data for repo " + repo.getName() + " (id=" + repositoryId + ") because it uses disabled or removed plugin"));
            return Optional.empty();
        }
        if (!moduleDescriptor.supportsBuildWarnings()) {
            log.debug((Object)("Can't send warning data for repo " + repo.getName() + " (id=" + repositoryId + ") because it doesn't support this feature"));
            return Optional.empty();
        }
        VcsBuildWarningsUpdater buildWarningsUpdater = moduleDescriptor.getBuildWarningsUpdater();
        if (buildWarningsUpdater == null || !buildWarningsUpdater.supportsBuildWarnings(repo)) {
            log.debug((Object)("Can't send warning data for repo " + repo.getName() + " (id=" + repositoryId + ") because it doesn't support this feature"));
            return Optional.empty();
        }
        return Optional.of(buildWarningsUpdater);
    }
}

