/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.HttpUtils;
import com.atlassian.sal.api.UrlMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BambooUrl {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public BambooUrl(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public String withBaseUrlFromConfiguration() {
        return this.withBaseUrlFromConfiguration(BambooUrl.getCurrentPathAndQuery());
    }

    @NotNull
    public String withBaseUrlFromConfiguration(@NotNull String path) {
        AdministrationConfiguration admCfg = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        String baseUrl = StringUtils.removeEnd((String)admCfg.getBaseUrl(), (String)"/");
        return baseUrl + StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    @NotNull
    public String withRelativeUrl() {
        return BambooUrl.getCurrentPathAndQuery();
    }

    @NotNull
    public String withBaseUrlFromRequest() {
        return this.withBaseUrlFromRequest(BambooUrl.getCurrentPathAndQuery());
    }

    @NotNull
    public String withBaseUrlFromRequest(@NotNull String path) {
        HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        int port = request.getServerPort();
        if (!HttpUtils.isDefaultPort((String)scheme, (int)port)) {
            url.append(":").append(port);
        }
        return url.append(request.getContextPath()).append(path).toString();
    }

    @NotNull
    public static String getCurrentPathAndQuery() {
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        String queryString = request.getQueryString();
        return request.getServletPath() + (queryString == null ? "" : "?" + queryString);
    }

    public String rootContext() {
        return RequestCacheThreadLocal.getNonNullRequest().getContextPath();
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case CANONICAL: {
                return this.getCanonicalBaseUrl();
            }
            case ABSOLUTE: {
                return this.getBaseUrlFromRequest().orElseGet(this::getCanonicalBaseUrl);
            }
            case RELATIVE: {
                return this.getContextPathFromRequest().orElseGet(this::getCanonicalContextPath);
            }
            case RELATIVE_CANONICAL: {
                return this.getCanonicalContextPath();
            }
            case AUTO: {
                return this.getContextPathFromRequest().orElseGet(this::getCanonicalBaseUrl);
            }
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private String getCanonicalBaseUrl() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
    }

    private String getCanonicalContextPath() {
        String baseUrl = this.getCanonicalBaseUrl();
        try {
            return new URL(baseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Base URL misconfigured", e);
        }
    }

    private Optional<String> getBaseUrlFromRequest() {
        HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        if (request != null) {
            return Optional.of(UrlUtils.constructBaseUrl((HttpServletRequest)request));
        }
        return Optional.empty();
    }

    private Optional<String> getContextPathFromRequest() {
        HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        if (request != null) {
            return Optional.of(request.getContextPath());
        }
        return Optional.empty();
    }
}

