/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.exception.DefaultWebValidationException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooValidationUtils {
    public static void validateField(@NotNull String fieldName, boolean validationCondition, @NotNull Supplier<String> errorMessageSupplier) throws WebValidationException {
        if (!validationCondition) {
            throw new WebValidationException(fieldName, errorMessageSupplier.get());
        }
    }

    @Deprecated
    public static void validate(boolean validationCondition, @NotNull String errorMessage) throws WebValidationException {
        if (!validationCondition) {
            throw new WebValidationException(errorMessage);
        }
    }

    public static void validate(boolean validationCondition, @NotNull Supplier<String> errorMessageSupplier) throws WebValidationException {
        if (!validationCondition) {
            throw new WebValidationException(errorMessageSupplier.get());
        }
    }

    public static void checkErrors(@NotNull ErrorCollection errorCollection) throws WebValidationException {
        if (errorCollection.hasAnyErrors()) {
            throw new DefaultWebValidationException(errorCollection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isStringRepresentingEnum(@NotNull Class<? extends Enum> enumClass, @Nullable String value) {
        if (StringUtils.isBlank((CharSequence)value)) return false;
        if (!Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).anyMatch(value::equals)) return false;
        return true;
    }
}

