/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.labels.LabelCount;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.comparator.StringPropertyComparator;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.DescriptionProvider;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.variable.VariableComparators;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Comparators {
    private static final Logger log = Logger.getLogger(Comparators.class);
    private static final Ordering<BambooIdProvider> bambooIdProviderOrdering = Ordering.natural().onResultOf(BambooFunctions.getBambooObjectId());

    private Comparators() {
    }

    @NotNull
    public static Comparator<ResultsSummary> getBuildCompletedDateComparator() {
        return BuildCompletedDateComparator.INSTANCE;
    }

    @NotNull
    public static Ordering<ResultStatisticsProvider> getBuildDateOrdering() {
        return BuildDateComparator.ORDERING;
    }

    @NotNull
    public static Ordering<ImmutablePlan> getBranchUpdatedDateOrdering() {
        return BranchUpdatedDateComparator.ORDERING;
    }

    @NotNull
    public static Ordering<DescriptionProvider> getDescriptionProviderOrdering() {
        return DescriptionProviderComparator.ORDERING;
    }

    @NotNull
    public static Comparator<LabelCount> getLabelCountAlphabeticComparator() {
        return LabelCountAlphabeticComparator.INSTANCE;
    }

    @NotNull
    public static Comparator<LabelCount> getLabelCountRankComparator() {
        return LabelCountRankComparator.INSTANCE;
    }

    @NotNull
    public static Ordering<NameProvider> getNameProviderOrdering() {
        return NameProviderComparator.ORDERING;
    }

    @NotNull
    public static <T extends ImmutableChain> Ordering<T> getTopLevelPlanNameProviderCaseInsensitiveOrdering() {
        return Ordering.from(new TopLevelPlanNameCaseInsensitiveComparator());
    }

    @NotNull
    public static Ordering<ImmutablePlan> getPlanNameProviderCaseInsensitiveOrdering() {
        return PlanNameCaseInsensitiveComparator.ORDERING;
    }

    @NotNull
    public static Ordering<NameProvider> getNameProviderCaseInsensitiveOrdering() {
        return NameProviderCaseInsensitiveComparator.ORDERING;
    }

    @NotNull
    public static <T> Comparator<T> stringPropertyComparator(@NotNull Class<T> beanClass, @NotNull String propertyName) {
        return StringPropertyComparator.stringPropertyComparator(beanClass, propertyName);
    }

    @NotNull
    public static <T> Comparator<T> stringPropertyCaseInsensitiveComparator(@NotNull Class<T> beanClass, @NotNull String propertyName) {
        return StringPropertyComparator.stringPropertyCaseInsensitiveComparator(beanClass, propertyName);
    }

    @NotNull
    public static Ordering<ResultsSummary> getResultsSummaryNumberOrdering() {
        return ResultsSummaryNumberComparator.ORDERING;
    }

    @NotNull
    public static Ordering<ResultsSummary> getResultsSummaryNameAndNumberComparator() {
        return ResultsSummaryPlanNameAndLatestNumberComparator.ORDERING;
    }

    public static int jobStagePlanNameCaseInsensitiveCompare(ImmutableJob o1, ImmutableJob o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
        }
        CompareToBuilder builder = new CompareToBuilder();
        if (o1.getStage() != null || o2.getStage() != null) {
            builder.append((Object)o1.getStage().getName(), (Object)o2.getStage().getName(), String.CASE_INSENSITIVE_ORDER);
        }
        builder.append((Object)o1.getBuildName(), (Object)o2.getBuildName(), String.CASE_INSENSITIVE_ORDER);
        return builder.toComparison();
    }

    @NotNull
    public static Comparator<String> getApplicationBuildNumberComparator() {
        return ApplicationBuildNumberComparator.INSTANCE;
    }

    @NotNull
    public static Ordering<ResultsSummary> getPlanNameResultOrdering() {
        return PlanNameResultsComparator.ORDERING;
    }

    @NotNull
    public static Ordering<VariableDefinitionContext> getVariableDefinitionContextOrdering() {
        return VariableComparators.getVariableDefinitionContextOrdering();
    }

    @NotNull
    public static Ordering<VariableDefinition> getVariableDefinitionOrdering() {
        return VariableComparators.getVariableDefinitionOrdering();
    }

    @NotNull
    public static Ordering<ModuleDescriptor<?>> getModuleDescriptorNameOrdering() {
        return BambooPluginUtils.getModuleDescriptorNameOrdering();
    }

    @NotNull
    public static Ordering<PlanResultKey> getPlanResultKeyOrdering() {
        return PlanResultKeyComparator.ORDERING;
    }

    @NotNull
    public static Ordering<BambooIdProvider> getBambooIdProviderOrdering() {
        return bambooIdProviderOrdering;
    }

    public static <T extends Comparable<T>> boolean isGreater(@NotNull T o1, @NotNull T o2) {
        return Comparators.isGreater(o1, o2, Comparator.naturalOrder());
    }

    public static <T> boolean isGreater(@NotNull T o1, @NotNull T o2, @NotNull Comparator<T> comparator) {
        return comparator.compare(Preconditions.checkNotNull(o1), Preconditions.checkNotNull(o2)) > 0;
    }

    public static <T> boolean isGreaterOrEqual(@NotNull T o1, @NotNull T o2, @NotNull Comparator<T> comparator) {
        return comparator.compare(Preconditions.checkNotNull(o1), Preconditions.checkNotNull(o2)) >= 0;
    }

    public static <T> boolean isLesser(@NotNull T o1, @NotNull T o2, @NotNull Comparator<T> comparator) {
        return comparator.compare(Preconditions.checkNotNull(o1), Preconditions.checkNotNull(o2)) < 0;
    }

    public static <T> boolean isLesserOrEqual(@NotNull T o1, @NotNull T o2, @NotNull Comparator<T> comparator) {
        return comparator.compare(Preconditions.checkNotNull(o1), Preconditions.checkNotNull(o2)) <= 0;
    }

    private static enum PlanResultKeyComparator implements Comparator<PlanResultKey>
    {
        INSTANCE;

        public static final Ordering<PlanResultKey> ORDERING;

        @Override
        public int compare(PlanResultKey o1, PlanResultKey o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getKey(), (Object)o2.getKey()).toComparison();
        }

        static {
            ORDERING = Ordering.from((Comparator)INSTANCE);
        }
    }

    private static class PlanNameResultsComparator
    implements Comparator<ResultsSummary> {
        public static final Ordering<ResultsSummary> ORDERING = Ordering.from((Comparator)new PlanNameResultsComparator());

        private PlanNameResultsComparator() {
        }

        @Override
        public int compare(ResultsSummary o1, ResultsSummary o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            String name1 = this.getNameSafe(o1);
            String name2 = this.getNameSafe(o2);
            return new CompareToBuilder().append((Object)name1, (Object)name2).toComparison();
        }

        @NotNull
        private String getNameSafe(ResultsSummary resultsSummary) {
            try {
                return resultsSummary.getImmutablePlan().getName();
            }
            catch (Exception e) {
                return resultsSummary.getPlanKey().getKey();
            }
        }
    }

    private static enum ApplicationBuildNumberComparator implements Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String o1, String o2) throws NumberFormatException {
            Integer number1 = Integer.valueOf(o1);
            Integer number2 = Integer.valueOf(o2);
            return number1.compareTo(number2);
        }
    }

    private static class ResultsSummaryPlanNameAndLatestNumberComparator
    implements Comparator<ResultsSummary> {
        public static final Ordering<ResultsSummary> ORDERING = Ordering.from((Comparator)new ResultsSummaryPlanNameAndLatestNumberComparator());

        private ResultsSummaryPlanNameAndLatestNumberComparator() {
        }

        @Override
        public int compare(ResultsSummary o1, ResultsSummary o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            int nameResult = PlanNameCaseInsensitiveComparator.ORDERING.compare((Object)o1.getImmutablePlan(), (Object)o2.getImmutablePlan());
            if (nameResult == 0) {
                return -1 * new CompareToBuilder().append(o1.getBuildNumber(), o2.getBuildNumber()).toComparison();
            }
            return nameResult;
        }
    }

    private static class ResultsSummaryNumberComparator
    implements Comparator<ResultsSummary> {
        public static final Ordering<ResultsSummary> ORDERING = Ordering.from((Comparator)new ResultsSummaryNumberComparator());

        private ResultsSummaryNumberComparator() {
        }

        @Override
        public int compare(ResultsSummary o1, ResultsSummary o2) {
            return new CompareToBuilder().append(o1 == null ? -1 : o1.getBuildNumber(), o2 == null ? -1 : o2.getBuildNumber()).toComparison();
        }
    }

    private static class PlanNameCaseInsensitiveComparator
    implements Comparator<ImmutablePlan> {
        public static final Ordering<ImmutablePlan> ORDERING = Ordering.from((Comparator)new PlanNameCaseInsensitiveComparator());

        private PlanNameCaseInsensitiveComparator() {
        }

        @Override
        public int compare(ImmutablePlan p1, ImmutablePlan p2) {
            if (p1 == null || p2 == null) {
                return p1 == p2 ? 0 : (p1 == null ? -1 : 1);
            }
            CompareToBuilder compareToBuilder = new CompareToBuilder();
            compareToBuilder.append((Object)p1.getProject().getName(), (Object)p2.getProject().getName(), String.CASE_INSENSITIVE_ORDER);
            Job j1 = (Job)Narrow.to((Object)p1, Job.class);
            Job j2 = (Job)Narrow.to((Object)p2, Job.class);
            if (j1 != null || j2 != null) {
                compareToBuilder.append((Object)(j1 == null ? null : j1.getParent().getBuildName()), (Object)(j2 == null ? null : j2.getParent().getBuildName()), String.CASE_INSENSITIVE_ORDER);
            }
            compareToBuilder.append((Object)p1.getBuildName(), (Object)p2.getBuildName(), String.CASE_INSENSITIVE_ORDER);
            return compareToBuilder.toComparison();
        }
    }

    private static class TopLevelPlanNameCaseInsensitiveComparator<T extends ImmutableChain>
    implements Comparator<T> {
        private TopLevelPlanNameCaseInsensitiveComparator() {
        }

        @Override
        public int compare(T p1, T p2) {
            if (p1 == null || p2 == null) {
                return p1 == p2 ? 0 : (p1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)p1.getProject().getName(), (Object)p2.getProject().getName(), String.CASE_INSENSITIVE_ORDER).append((Object)p1.getBuildName(), (Object)p2.getBuildName(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }
    }

    private static class NameProviderCaseInsensitiveComparator
    implements Comparator<NameProvider> {
        public static final Ordering<NameProvider> ORDERING = Ordering.from((Comparator)new NameProviderCaseInsensitiveComparator());

        private NameProviderCaseInsensitiveComparator() {
        }

        @Override
        public int compare(NameProvider o1, NameProvider o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getName(), (Object)o2.getName(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }
    }

    private static class NameProviderComparator
    implements Comparator<NameProvider> {
        public static final Ordering<NameProvider> ORDERING = Ordering.from((Comparator)new NameProviderComparator());

        private NameProviderComparator() {
        }

        @Override
        public int compare(NameProvider o1, NameProvider o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getName(), (Object)o2.getName()).toComparison();
        }
    }

    private static enum LabelCountRankComparator implements Comparator<LabelCount>
    {
        INSTANCE;


        @Override
        public int compare(LabelCount o1, LabelCount o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append(o2.getCount(), o1.getCount()).toComparison();
        }
    }

    private static enum LabelCountAlphabeticComparator implements Comparator<LabelCount>
    {
        INSTANCE;


        @Override
        public int compare(LabelCount o1, LabelCount o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getLabel().getName(), (Object)o2.getLabel().getName(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }
    }

    private static enum ElasticImageConfigurationNameComparator implements Comparator<ElasticImageConfiguration>
    {
        INSTANCE;


        @Override
        public int compare(ElasticImageConfiguration o1, ElasticImageConfiguration o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getConfigurationName(), (Object)o2.getConfigurationName(), String.CASE_INSENSITIVE_ORDER).toComparison();
        }
    }

    private static class DescriptionProviderComparator
    implements Comparator<DescriptionProvider> {
        public static final Ordering<DescriptionProvider> ORDERING = Ordering.from((Comparator)new DescriptionProviderComparator());

        private DescriptionProviderComparator() {
        }

        @Override
        public int compare(DescriptionProvider o1, DescriptionProvider o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getName(), (Object)o2.getName()).append((Object)o1.getDescription(), (Object)o2.getDescription()).toComparison();
        }
    }

    private static class BuildDateComparator
    implements Comparator<ResultStatisticsProvider> {
        public static final Ordering<ResultStatisticsProvider> ORDERING = Ordering.from((Comparator)new BuildDateComparator());

        private BuildDateComparator() {
        }

        @Override
        public int compare(ResultStatisticsProvider o1, ResultStatisticsProvider o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getBuildDate(), (Object)o2.getBuildDate()).toComparison();
        }
    }

    private static enum BuildCompletedDateComparator implements Comparator<ResultsSummary>
    {
        INSTANCE;


        @Override
        public int compare(ResultsSummary o1, ResultsSummary o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)(o1.getBuildCompletedDate() != null ? o1.getBuildCompletedDate() : o1.getBuildDate()), (Object)(o2.getBuildCompletedDate() != null ? o2.getBuildCompletedDate() : o2.getBuildDate())).toComparison();
        }
    }

    private static class BranchUpdatedDateComparator
    implements Comparator<ImmutablePlan> {
        public static final Ordering<ImmutablePlan> ORDERING = Ordering.from((Comparator)new BranchUpdatedDateComparator());

        private BranchUpdatedDateComparator() {
        }

        @Override
        public int compare(ImmutablePlan o1, ImmutablePlan o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            if (o1.isSuspendedFromBuilding() != o2.isSuspendedFromBuilding()) {
                return (o1.isSuspendedFromBuilding() ? 0 : 1) - (o2.isSuspendedFromBuilding() ? 0 : 1);
            }
            BranchCommitInformation commitInformation1 = o1 instanceof ImmutableChainBranch ? ((ImmutableChainBranch)o1).getCommitInformation() : ((ImmutableChainBranch)((ImmutableJob)o1).getParent()).getCommitInformation();
            BranchCommitInformation commitInformation2 = o2 instanceof ImmutableChainBranch ? ((ImmutableChainBranch)o2).getCommitInformation() : ((ImmutableChainBranch)((ImmutableJob)o2).getParent()).getCommitInformation();
            return new CompareToBuilder().append((Object)(commitInformation1 != null ? commitInformation1.getLatestCommitDate() : null), (Object)(commitInformation2 != null ? commitInformation2.getLatestCommitDate() : null)).append((Object)(commitInformation1 != null ? commitInformation1.getCreatingCommitDate() : null), (Object)(commitInformation2 != null ? commitInformation2.getCreatingCommitDate() : null)).toComparison();
        }
    }
}

