/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.v2.build.timing.BuildTimingPoint;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DebugUtils {
    private final Logger log;

    private DebugUtils(Logger log) {
        this.log = log;
    }

    public static DebugUtils withLog(Logger log) {
        return new DebugUtils(log);
    }

    public static void logTimingPoint(String label, BuildTimingPoint event, Logger log1) {
        if (log1.isDebugEnabled()) {
            log1.debug((Object)String.format(label + " for %s", event.getPlanResultKey()));
        }
    }

    public DebugUtils logId(String fieldName, Object o) {
        this.log.info((Object)(fieldName + " (id): " + ObjectUtils.identityToString((Object)o)));
        return this;
    }

    public DebugUtils logStack() {
        this.log.info((Object)"Current stack:", (Throwable)new RuntimeException());
        return this;
    }

    public static void toggleSQLLogging(Level logLevel) {
        LogManager.getLogger((String)"org.hibernate.SQL").setLevel(logLevel);
    }
}

