/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.struts.ValidationAware;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorCollectionUtils {
    private ErrorCollectionUtils() {
    }

    public static void addErrorCollection(@NotNull ValidationAware validationAware, @Nullable ErrorCollection errorCollection) {
        if (errorCollection != null) {
            Collection currentErrorMessages = validationAware.getActionErrors();
            currentErrorMessages.addAll(errorCollection.getErrorMessages());
            validationAware.setActionErrors(currentErrorMessages);
            for (Map.Entry entry : errorCollection.getFieldErrors().entrySet()) {
                String fieldKey = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Collection) {
                    for (String message : (Collection)value) {
                        validationAware.addFieldError(fieldKey, message);
                    }
                    continue;
                }
                if (value instanceof String) {
                    validationAware.addFieldError(fieldKey, (String)value);
                    continue;
                }
                throw new IllegalArgumentException("Added error value must be a collection or a string. Object is " + value + " and key is " + fieldKey);
            }
        }
    }

    public static void addFieldErrors(@NotNull ValidationAware validationAware, @NotNull Map<String, String> fieldErrors) {
        for (Map.Entry<String, String> entry : fieldErrors.entrySet()) {
            String fieldKey = entry.getKey();
            String errorMessage = entry.getValue();
            validationAware.addFieldError(fieldKey, errorMessage);
        }
    }
}

