/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileCopier {
    private FileCopier() {
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IoOutputException, IoInputException {
        byte[] buffer = new byte[4096];
        try {
            int numberRead;
            while ((numberRead = inputStream.read(buffer)) != -1) {
                FileCopier.write(outputStream, numberRead, buffer);
            }
        }
        catch (IoOutputException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IoInputException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private static void write(OutputStream outputStream, int numberRead, byte[] buffer) throws IoOutputException {
        try {
            outputStream.write(buffer, 0, numberRead);
        }
        catch (IOException e) {
            throw new IoOutputException(e);
        }
    }

    public static class IoInputException
    extends IOException {
        public IoInputException(IOException e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }

    public static class IoOutputException
    extends IOException {
        public IoOutputException(IOException e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }
}

