/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.amazonaws.ClientConfiguration;
import org.apache.commons.lang3.math.NumberUtils;

public class HttpClientConfigurationUtils {
    private static final String HTTPS = "https";
    private static final String HTTP = "http";

    private HttpClientConfigurationUtils() {
    }

    public static ClientConfiguration newClientConfiguration(int transmissionTimeoutMs, int maxRetries) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        HttpClientConfigurationUtils.applyTimeoutSettings(clientConfiguration, transmissionTimeoutMs, maxRetries);
        HttpClientConfigurationUtils.applyProxyProperties(clientConfiguration);
        return clientConfiguration;
    }

    public static ClientConfiguration applyTimeoutSettings(ClientConfiguration clientConfiguration, int timeoutMs, int maxRetries) {
        return clientConfiguration.withSocketTimeout(timeoutMs).withConnectionTimeout(timeoutMs).withMaxErrorRetry(maxRetries);
    }

    public static ClientConfiguration applyProxyProperties(ClientConfiguration clientConfiguration) {
        if (!HttpClientConfigurationUtils.applyProxyProperties(clientConfiguration, HTTPS)) {
            HttpClientConfigurationUtils.applyProxyProperties(clientConfiguration, HTTP);
        }
        return clientConfiguration;
    }

    private static boolean applyProxyProperties(ClientConfiguration clientConfiguration, String protocol) {
        String proxyHost = HttpClientConfigurationUtils.getSystemProperty(protocol, "proxyHost");
        String proxyPortString = HttpClientConfigurationUtils.getSystemProperty(protocol, "proxyPort");
        int proxyPort = NumberUtils.toInt((String)proxyPortString, (int)-1);
        if (proxyHost == null || proxyPort <= 0) {
            return false;
        }
        clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort);
        String proxyDomain = HttpClientConfigurationUtils.getSystemProperty(protocol, "proxyDomain");
        String proxyUser = HttpClientConfigurationUtils.getSystemProperty(protocol, "proxyUser");
        String proxyPassword = HttpClientConfigurationUtils.getSystemProperty(protocol, "proxyPassword");
        String proxyWorkstation = HttpClientConfigurationUtils.getSystemProperty(protocol, "proxyWorkstation");
        clientConfiguration.withProxyUsername(proxyUser).withProxyPassword(proxyPassword).withProxyDomain(proxyDomain).withProxyWorkstation(proxyWorkstation);
        return true;
    }

    private static String getSystemProperty(String protocol, String proxyHost) {
        return System.getProperty(protocol + "." + proxyHost);
    }
}

