/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.util.pagination.PaginatedDataCollector;
import com.atlassian.bamboo.util.pagination.PaginatedDataProvider;
import com.atlassian.bamboo.util.pagination.PaginationRequest;
import com.atlassian.bamboo.util.pagination.PaginationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PaginatedDataCollectorImpl
implements PaginatedDataCollector {
    @NotNull
    public <T> PaginationResult<T> collect(PaginationRequest<T> request, @NotNull PaginatedDataProvider<T> provider) {
        ArrayList result = new ArrayList();
        boolean hasMore = true;
        int start = request.getStart();
        int limit = request.getLimit();
        boolean firstLoopCall = true;
        LimitedCumulatedPredicate predicate = new LimitedCumulatedPredicate(request.getOrderedFilters(), limit);
        while (result.size() < limit && hasMore) {
            predicate.resetBufferOverflow();
            int howManyEntriesToFetchInThisLoop = request.getBatchSize();
            if (firstLoopCall) {
                firstLoopCall = false;
                ++howManyEntriesToFetchInThisLoop;
            }
            List partialData = provider.provideData(start, howManyEntriesToFetchInThisLoop);
            List afterFiltering = partialData.stream().filter(predicate).collect(Collectors.toList());
            result.addAll(afterFiltering);
            hasMore = partialData.size() == howManyEntriesToFetchInThisLoop || predicate.getBufferOverlowIndex() < partialData.size();
            start += predicate.getBufferOverlowIndex();
        }
        PaginationResult response = new PaginationResult(result, request.getStart(), request.getLimit());
        if (hasMore) {
            response.setHasNext(true);
            response.setNextStart(request.getStart() + predicate.getEntriesTested());
        }
        return response;
    }

    private static class LimitedCumulatedPredicate<T>
    implements Predicate<T> {
        private int currentRecords = 0;
        private final List<Predicate<T>> predicates;
        private final int elementsToFetch;
        private int entriesTested = 0;
        private int bufferOverlowIndex;

        private LimitedCumulatedPredicate(List<Predicate<T>> predicates, int elementsToFetch) {
            this.predicates = predicates;
            this.elementsToFetch = elementsToFetch;
        }

        @Override
        public boolean test(T t) {
            if (this.currentRecords >= this.elementsToFetch) {
                return false;
            }
            ++this.entriesTested;
            ++this.bufferOverlowIndex;
            for (Predicate<T> predicate : this.predicates) {
                if (predicate.test(t)) continue;
                return false;
            }
            ++this.currentRecords;
            return true;
        }

        private int getEntriesTested() {
            return this.entriesTested;
        }

        private void resetBufferOverflow() {
            this.bufferOverlowIndex = 0;
        }

        public int getBufferOverlowIndex() {
            return this.bufferOverlowIndex;
        }
    }
}

