/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.log4j.Logger;

public class RandomGUID {
    private static final Logger log = Logger.getLogger(RandomGUID.class);
    private String myValueAfterMD5 = "";
    private static final Random myRand;
    private static final SecureRandomService secureRandom;
    private static String s_id;

    public RandomGUID() {
        this.generateRandomGUID(false);
    }

    public RandomGUID(boolean secure) {
        this.generateRandomGUID(secure);
    }

    private void generateRandomGUID(boolean secure) {
        MessageDigest md5;
        StringBuilder sbValueBeforeMD5 = new StringBuilder();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Problem generating GUID: " + e));
            return;
        }
        try {
            long time = System.currentTimeMillis();
            long rand = secure ? secureRandom.nextLong() : myRand.nextLong();
            sbValueBeforeMD5.append(s_id);
            sbValueBeforeMD5.append(':');
            sbValueBeforeMD5.append(Long.toString(time));
            sbValueBeforeMD5.append(':');
            sbValueBeforeMD5.append(Long.toString(rand));
            String valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuilder sb = new StringBuilder();
            for (byte value : array) {
                int b = value & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            this.myValueAfterMD5 = sb.toString();
        }
        catch (Exception e) {
            log.error((Object)("Problem generating GUID: " + e));
        }
    }

    public String toString() {
        String raw = this.myValueAfterMD5.toUpperCase();
        StringBuilder sb = new StringBuilder();
        sb.append(raw.substring(0, 8));
        sb.append('-');
        sb.append(raw.substring(8, 12));
        sb.append('-');
        sb.append(raw.substring(12, 16));
        sb.append('-');
        sb.append(raw.substring(16, 20));
        sb.append('-');
        sb.append(raw.substring(20));
        return sb.toString();
    }

    static {
        secureRandom = DefaultSecureRandomService.getInstance();
        myRand = new Random(secureRandom.nextLong());
        try {
            s_id = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
        }
    }
}

