/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RequirementUtils {
    public static boolean updateRequirement(RequirementSet requirementSet, String newRequirementKey, String oldRequirementKey, boolean override) {
        Set<Requirement> requirementsToMove = requirementSet.getRequirements().stream().filter(requirement -> requirement.getKey().equals(oldRequirementKey)).collect(Collectors.toSet());
        if (!requirementsToMove.isEmpty()) {
            Set requirementsInTheWay = requirementSet.getRequirements().stream().filter(requirement -> requirement.getKey().equals(newRequirementKey)).collect(Collectors.toSet());
            if (requirementsInTheWay.isEmpty()) {
                requirementsToMove.forEach(item -> item.setKey(newRequirementKey));
            } else if (override) {
                requirementSet.removeRequirements(item -> item.getKey().equals(newRequirementKey));
                requirementsToMove.forEach(item -> item.setKey(newRequirementKey));
            } else {
                requirementSet.removeRequirements(item -> item.getKey().equals(oldRequirementKey));
            }
            return true;
        }
        return false;
    }

    public static class MinimalRequirementSetImpl
    implements MinimalRequirementSet {
        private Set<ImmutableRequirement> requirements;

        public MinimalRequirementSetImpl(ImmutableRequirement ... requirements) {
            this.requirements = Sets.newHashSet((Object[])requirements);
        }

        @NotNull
        public Set<ImmutableRequirement> getRequirements() {
            return this.requirements;
        }

        public ImmutableRequirement getRequirement(long requirementId) {
            return this.requirements.stream().filter(r -> r.getId() == requirementId).findFirst().orElse(null);
        }
    }
}

