/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.setup.BootstrapManager;
import com.google.common.base.Preconditions;
import com.opensymphony.util.ClassLoaderUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceResolver {
    private static final Logger log = Logger.getLogger(ResourceResolver.class);
    @Nullable
    private final BootstrapManager bootstrapManager;
    private final ResourceResolutionStrategy[] resourceResolutionStrategies = new ResourceResolutionStrategy[]{new ResourceResolutionStrategy(){

        @Override
        public URL findResource(@NotNull String resourceName) {
            if (ResourceResolver.this.bootstrapManager == null) {
                return null;
            }
            File file = new File(ResourceResolver.this.bootstrapManager.getConfigDirectory(), resourceName);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Unable to convert file to url. Null being returned " + file.getAbsolutePath()), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }, new ResourceResolutionStrategy(){

        @Override
        public URL findResource(@NotNull String resourceName) {
            File file = new File(resourceName);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Unable to convert file to url. Null being returned " + file.getAbsolutePath()), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }, new ResourceResolutionStrategy(){

        @Override
        public URL findResource(@NotNull String resourceName) {
            return ClassLoaderUtil.getResource((String)resourceName, this.getClass());
        }
    }};

    public ResourceResolver(@Nullable BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Nullable
    public URL findResource(@NotNull String resourceName) {
        Preconditions.checkArgument((resourceName != null ? 1 : 0) != 0);
        for (ResourceResolutionStrategy strategy : this.resourceResolutionStrategies) {
            URL resource = strategy.findResource(resourceName);
            if (resource == null) continue;
            return resource;
        }
        log.warn((Object)("Unable to find resource " + resourceName));
        return null;
    }

    static interface ResourceResolutionStrategy {
        @Nullable
        public URL findResource(@NotNull String var1);
    }
}

