/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.security.random.SecureRandomFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.openssl.PEMWriter;

public class SshKeysProvider {
    private final RSAKeyPairGenerator rsaKeyPairGenerator = new RSAKeyPairGenerator();
    private final KeyFactory rsaKeyFactory;

    public SshKeysProvider() throws NoSuchProviderException, NoSuchAlgorithmException {
        this.rsaKeyPairGenerator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(new BigInteger("10001", 16), SecureRandomFactory.newInstance(), 2048, 80));
        this.rsaKeyFactory = KeyFactory.getInstance("RSA", BouncyCastleProviderUtils.getProviderName());
    }

    public Pair<String, String> getRsaOpenSshKeyPair(String userComment) throws InvalidKeySpecException, IOException {
        AsymmetricCipherKeyPair kp = this.rsaKeyPairGenerator.generateKeyPair();
        RSAPrivateCrtKeyParameters rsapckp = (RSAPrivateCrtKeyParameters)kp.getPrivate();
        RSAKeyParameters rsakp = (RSAKeyParameters)kp.getPublic();
        RSAPrivateCrtKeySpec prvKeySpecs = new RSAPrivateCrtKeySpec(rsapckp.getModulus(), rsapckp.getPublicExponent(), rsapckp.getExponent(), rsapckp.getP(), rsapckp.getQ(), rsapckp.getDP(), rsapckp.getDQ(), rsapckp.getQInv());
        PrivateKey privateKey = this.rsaKeyFactory.generatePrivate(prvKeySpecs);
        String privateKeyPEM = this.getObjectAsPEM(privateKey);
        RSAPublicKeySpec pubKeySpecs = new RSAPublicKeySpec(rsakp.getModulus(), rsakp.getExponent());
        PublicKey publicKey = this.rsaKeyFactory.generatePublic(pubKeySpecs);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        String pkcsPublicKey = this.getRsaPublicKeyAsPKCS(rsaPublicKey, userComment);
        return Pair.make((Object)pkcsPublicKey, (Object)privateKeyPEM);
    }

    private String getObjectAsPEM(Object o) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);){
            pemWriter.writeObject(o);
            pemWriter.flush();
        }
        return stringWriter.toString();
    }

    private String getRsaPublicKeyAsPKCS(RSAPublicKey rsaPublicKey, String userComment) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(output);
        dos.writeInt("ssh-rsa".getBytes().length);
        dos.write("ssh-rsa".getBytes());
        dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
        dos.write(rsaPublicKey.getPublicExponent().toByteArray());
        dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
        dos.write(rsaPublicKey.getModulus().toByteArray());
        String enc = new String(Base64.getEncoder().encode(output.toByteArray()));
        dos.write(enc.getBytes());
        return "ssh-rsa " + enc + " " + userComment;
    }
}

