/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import org.jetbrains.annotations.Nullable;

public final class Wildcard {
    private static final char MANY = '*';
    private static final char SINGLE = '?';

    private Wildcard() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static boolean matches(@Nullable String pattern, @Nullable String text) {
        if (pattern == null || text == null) {
            return false;
        }
        text = text + '\u0000';
        pattern = pattern + '\u0000';
        int N = pattern.length();
        boolean[] states = new boolean[N + 1];
        boolean[] old = new boolean[N + 1];
        old[0] = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            states = new boolean[N + 1];
            for (int j = 0; j < N; ++j) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '?') {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (!old[j] || p != '*') continue;
                states[j + 1] = true;
            }
            old = states;
        }
        return states[N];
    }
}

