/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.commonsconfig.BambooXmlConfiguration;
import com.atlassian.bamboo.persister.AuditLogService;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class XmlDiffFinder {
    private final XMLConfiguration oldConfig;
    private final XMLConfiguration newConfig;
    private static final Logger log = Logger.getLogger(XmlDiffFinder.class);
    private final boolean isOrderImportant;

    public XmlDiffFinder(@NotNull String xmlData, @NotNull String newXmlData) {
        this(xmlData, newXmlData, false);
    }

    public XmlDiffFinder(@NotNull String xmlData, @NotNull String newXmlData, boolean isOrderImportant) {
        this.isOrderImportant = isOrderImportant;
        this.oldConfig = new BambooXmlConfiguration();
        this.newConfig = new BambooXmlConfiguration();
        try {
            this.oldConfig.load((Reader)new StringReader(xmlData));
            this.newConfig.load((Reader)new StringReader(newXmlData));
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Unable to parse xml data.", (Throwable)e);
        }
    }

    @NotNull
    public List<AuditLogService.FieldChange> findChanges() {
        LinkedList<AuditLogService.FieldChange> changes = new LinkedList<AuditLogService.FieldChange>();
        HashSet allOldKeys = Sets.newHashSet((Iterator)this.oldConfig.getKeys());
        for (String oldKey : allOldKeys) {
            Collection<String> newValue;
            Collection<String> oldValue = this.getValue(this.oldConfig, oldKey);
            if (oldValue.equals(newValue = this.getValue(this.newConfig, oldKey))) continue;
            changes.add(new DefaultFieldChange(oldKey, oldValue.toString(), newValue.toString()));
        }
        HashSet allNewKeys = Sets.newHashSet((Iterator)this.newConfig.getKeys());
        allNewKeys.removeAll(allOldKeys);
        for (String newKey : allNewKeys) {
            if (!StringUtils.isNotBlank((CharSequence)this.newConfig.getString(newKey))) continue;
            changes.add(new DefaultFieldChange(newKey, null, this.newConfig.getString(newKey)));
        }
        return changes;
    }

    private Collection<String> getValue(XMLConfiguration config, String key) {
        LinkedList<String> result = this.isOrderImportant ? new LinkedList() : new HashSet();
        for (Object s : config.getList(key)) {
            result.add(StringUtils.trimToEmpty((String)((String)s)));
        }
        return result;
    }

    public static class DefaultFieldChange
    implements AuditLogService.FieldChange {
        private final String fieldName;
        private final String oldValue;
        private final String newValue;

        public DefaultFieldChange(String fieldName, String oldValue, String newValue) {
            this.fieldName = fieldName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String toString() {
            return "[" + this.fieldName + "]: [" + this.oldValue + "]->[" + this.newValue + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultFieldChange that = (DefaultFieldChange)o;
            return Objects.equals(this.getFieldName(), that.getFieldName()) && Objects.equals(this.getOldValue(), that.getOldValue()) && Objects.equals(this.getNewValue(), that.getNewValue());
        }

        public int hashCode() {
            return Objects.hash(this.getFieldName(), this.getOldValue(), this.getNewValue());
        }
    }
}

