/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.SystemProperty;
import io.atlassian.util.concurrent.Lazy;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

public class XsrfUtils {
    private static final Logger log = Logger.getLogger(XsrfUtils.class);
    private static final boolean ALLOW_MUTATIVE_GET_IN_STRICT_XSRF_MODE = SystemProperty.ALLOW_MUTATIVE_GET_IN_STRICT_XSRF_MODE.getTypedValue();
    private static final Supplier<Boolean> ADMIN_CONFIG_ALLOWS_MUTATIVE_GETS = Lazy.timeToLive(() -> ((AdministrationConfiguration)ComponentAccessor.PROTOTYPE_ADMINISTRATION_CONFIGURATION.get()).doesXsrfAllowMutativeGets(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    private static final Supplier<Boolean> ADMIN_CONFIG_ENABLES_XSRF_PROTECTION = Lazy.timeToLive(() -> ((AdministrationConfiguration)ComponentAccessor.PROTOTYPE_ADMINISTRATION_CONFIGURATION.get()).isXsrfProtectionEnabled(), (long)5L, (TimeUnit)TimeUnit.SECONDS);

    private XsrfUtils() {
    }

    public static void fail(String s) {
        log.warn((Object)("XSRF: " + s));
        throw new IllegalStateException("XSRF: " + s);
    }

    public static boolean areMutativeGetsForbiddenByConfig() {
        return !ALLOW_MUTATIVE_GET_IN_STRICT_XSRF_MODE && ADMIN_CONFIG_ENABLES_XSRF_PROTECTION.get() != false && ADMIN_CONFIG_ALLOWS_MUTATIVE_GETS.get() == false;
    }

    public static boolean noRequestOrRequestCanMutateState() {
        return RequestCacheThreadLocal.getRequest() == null || RequestCacheThreadLocal.canRequestMutateState();
    }

    public static void assertCanPerformMutativeAction(String s) {
        if (XsrfUtils.noRequestOrRequestCanMutateState() || !XsrfUtils.areMutativeGetsForbiddenByConfig()) {
            return;
        }
        XsrfUtils.fail(s);
    }
}

