/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.archive;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.archive.Archiver;
import com.atlassian.bamboo.archive.ArchiverResolver;
import com.atlassian.bamboo.archive.ArchiverType;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class ArchiveUtils {
    private ArchiveUtils() {
    }

    public static void compressFiles(@NotNull ArchiverType archiverType, @NotNull Iterable<File> sourceFiles, @NotNull File archiveFile, @Nullable File baseDirectory) throws IOException {
        Preconditions.checkArgument((!archiveFile.exists() ? 1 : 0) != 0, (String)"Output archive file must not exist: %s", (Object[])new Object[]{archiveFile.getCanonicalPath()});
        if (baseDirectory != null) {
            Preconditions.checkArgument((boolean)baseDirectory.exists(), (String)"Base directory must exist: %s", (Object[])new Object[]{baseDirectory.getCanonicalPath()});
            Preconditions.checkArgument((boolean)baseDirectory.isDirectory(), (String)"Base directory must be a folder, not a file: %s", (Object[])new Object[]{baseDirectory.getCanonicalPath()});
        }
        for (File sourceFile : sourceFiles) {
            Preconditions.checkArgument((boolean)sourceFile.exists(), (String)"File to compress must exist: %s", (Object[])new Object[]{sourceFile.getCanonicalPath()});
            if (baseDirectory == null) continue;
            Preconditions.checkArgument((boolean)FileUtils.directoryContains((File)baseDirectory, (File)sourceFile), (String)"File %s not contained within parent directory %s", (Object[])new Object[]{sourceFile.getCanonicalFile(), baseDirectory.getCanonicalPath()});
        }
        Archiver archiver = ArchiverResolver.getArchiver(archiverType);
        archiver.compressFiles(sourceFiles, archiveFile, baseDirectory);
    }

    public static void extractArchive(@NotNull ArchiverType archiverType, @NotNull File archiveFile, @NotNull File destinationDirectory) throws IOException {
        Preconditions.checkArgument((boolean)archiveFile.exists(), (String)"Archive file must exist: %s", (Object[])new Object[]{archiveFile.getCanonicalPath()});
        Preconditions.checkArgument((boolean)destinationDirectory.exists(), (String)"Destination directory must exist: %s", (Object[])new Object[]{destinationDirectory.getCanonicalPath()});
        Preconditions.checkArgument((boolean)destinationDirectory.isDirectory(), (String)"Destination directory must be a folder, not a file: %s", (Object[])new Object[]{destinationDirectory.getCanonicalPath()});
        Archiver archiver = ArchiverResolver.getArchiver(archiverType);
        archiver.extractArchive(archiveFile, destinationDirectory);
    }
}

