/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.expirables;

import com.atlassian.bamboo.expirables.Expirable;
import com.atlassian.bamboo.expirables.ExpiryHandler;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import com.atlassian.bamboo.utils.BambooTimeValue;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public final class ExpiryHandlerImpl
implements ExpiryHandler {
    private final Expirable expirable;
    private final ExpiryTicker expiryTicker;
    private long expiryDeadline;
    private final long ttlNanos;

    @Deprecated
    public ExpiryHandlerImpl(@NotNull Expirable expiring, @NotNull BambooTimeValue timeToIdle, @NotNull ExpiryTicker expiryTicker) {
        this.expirable = expiring;
        this.expiryTicker = expiryTicker;
        this.ttlNanos = timeToIdle.toNanos();
    }

    public ExpiryHandlerImpl(@NotNull Expirable expiring, @NotNull Duration timeToIdle, @NotNull ExpiryTicker expiryTicker) {
        this.expirable = expiring;
        this.expiryTicker = expiryTicker;
        this.ttlNanos = timeToIdle.toNanos();
    }

    public void onCreate() {
        this.expiryTicker.register((ExpiryHandler)this);
    }

    public void onUse() {
        this.expiryDeadline = System.nanoTime() + this.ttlNanos;
    }

    public long expiryTick() {
        if (System.nanoTime() > this.expiryDeadline) {
            this.expirable.expire();
            return -1L;
        }
        return this.expiryDeadline;
    }
}

