/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.expirables;

import com.atlassian.bamboo.expirables.ExpiryHandler;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public final class ExpiryTickerImpl
implements ExpiryTicker {
    private static final Logger log = Logger.getLogger(ExpiryTickerImpl.class);
    private final Collection<ExpiryHandler> expiryHandlers = new HashSet<ExpiryHandler>();

    public synchronized boolean register(ExpiryHandler expiring) {
        return this.expiryHandlers.add(expiring);
    }

    public synchronized void tick() {
        HashSet<ExpiryHandler> toRemove = new HashSet<ExpiryHandler>();
        for (ExpiryHandler expiryHandler : this.expiryHandlers) {
            if (expiryHandler.expiryTick() >= 0L) continue;
            toRemove.add(expiryHandler);
            log.debug((Object)("Will expire " + expiryHandler));
        }
        this.expiryHandlers.removeAll(toRemove);
        log.debug((Object)("Live expiry handlers: " + this.expiryHandlers.size()));
    }
}

