/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.functions;

import com.google.common.base.Function;
import io.atlassian.fugue.Functions;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.log4j.Logger;

public class Numeric {
    private static final Logger log = Logger.getLogger(Numeric.class);

    public static BiFunction<Long, Long, Long> addLong() {
        return AddLong.INSTANCE;
    }

    public static Function<List<Long>, Long> foldListOfLong() {
        return FoldListOfLong.INSTANCE;
    }

    public static BiFunction<Long, Long, Long> max() {
        return Max.INSTANCE;
    }

    private static enum Max implements BiFunction<Long, Long, Long>
    {
        INSTANCE;


        @Override
        public Long apply(Long arg1, Long arg2) {
            return Math.max(arg1, arg2);
        }
    }

    private static enum FoldListOfLong implements Function<List<Long>, Long>
    {
        INSTANCE;


        public Long apply(List<Long> input) {
            return (Long)Functions.fold(Numeric.addLong(), (Object)0L, input);
        }
    }

    private static enum AddLong implements BiFunction<Long, Long, Long>
    {
        INSTANCE;


        @Override
        public Long apply(Long arg1, Long arg2) {
            return arg1 + arg2;
        }
    }
}

