/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.i18n;

import com.atlassian.bamboo.plugin.BambooPluginManager;
import com.atlassian.bamboo.plugin.PluginAwareStrutsLocalizedTextProvider;
import com.atlassian.struts.TextProvider;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork2.DefaultTextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public class BambooTextProvider
extends DefaultTextProvider
implements TextProvider,
com.opensymphony.xwork.TextProvider {
    private static volatile ClassLoader webAppClassLoader;
    private static ClassLoader overriddenClassLoader;
    private static final BambooTextProvider INSTANCE;

    private BambooTextProvider() {
        this.setLocalizedTextProvider(PluginAwareStrutsLocalizedTextProvider.getInstance());
    }

    public static BambooTextProvider getInstance() {
        return INSTANCE;
    }

    private Object beforeCall() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != overriddenClassLoader) {
            return null;
        }
        Thread.currentThread().setContextClassLoader(webAppClassLoader);
        return contextClassLoader;
    }

    private void afterCall(Object context) {
        if (context != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)context);
        }
    }

    public static void setWebAppClassLoader(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader, (Object)"All seeing classloader cannot be null");
        webAppClassLoader = classLoader;
        ClassLoader systemClassLoader = BambooPluginManager.class.getClassLoader();
        if (systemClassLoader != webAppClassLoader) {
            overriddenClassLoader = systemClassLoader;
        }
    }

    public static ClassLoader getMainAppClassloader() {
        Preconditions.checkNotNull((Object)webAppClassLoader, (Object)"Unable to register i18n resources in the central classloader");
        return webAppClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey(String key) {
        Object context = this.beforeCall();
        try {
            boolean bl = super.hasKey(key);
            return bl;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key) {
        Object context = this.beforeCall();
        try {
            String string = StringUtils.defaultString((String)super.getText(key), (String)key);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String defaultValue) {
        Object context = this.beforeCall();
        try {
            String string = super.getText(key, defaultValue);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, List args) {
        Object context = this.beforeCall();
        try {
            String string = StringUtils.defaultString((String)super.getText(key, args), (String)key);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String[] args) {
        Object context = this.beforeCall();
        try {
            String string = StringUtils.defaultString((String)super.getText(key, args), (String)key);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String defaultValue, List args) {
        Object context = this.beforeCall();
        try {
            String string = super.getText(key, defaultValue, args);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String defaultValue, String[] args) {
        Object context = this.beforeCall();
        try {
            String string = super.getText(key, defaultValue, args);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String defaultValue, String obj) {
        Object context = this.beforeCall();
        try {
            String string = super.getText(key, defaultValue, obj);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String defaultValue, List<?> args, ValueStack stack) {
        Object context = this.beforeCall();
        try {
            String string = super.getText(key, defaultValue, args, stack);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        Object context = this.beforeCall();
        try {
            String string = super.getText(key, defaultValue, args, stack);
            return string;
        }
        finally {
            this.afterCall(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getTexts(String bundleName) {
        Object context = this.beforeCall();
        try {
            ResourceBundle resourceBundle = super.getTexts(bundleName);
            return resourceBundle;
        }
        finally {
            this.afterCall(context);
        }
    }

    public ResourceBundle getTexts() {
        Object context = this.beforeCall();
        try {
            ResourceBundle resourceBundle = super.getTexts();
            return resourceBundle;
        }
        finally {
            this.afterCall(context);
        }
    }

    @Deprecated
    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        return this.getText(key, defaultValue, args, (ValueStack)stack);
    }

    @Deprecated
    public String getText(String key, String defaultValue, String[] args, OgnlValueStack stack) {
        return this.getText(key, defaultValue, args, (ValueStack)stack);
    }

    static {
        overriddenClassLoader = null;
        INSTANCE = new BambooTextProvider();
    }
}

