/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.i18n;

import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DefaultDocumentationLinkProvider
implements DocumentationLinkProvider {
    static final String DOC_ROOT_KEY = "help.prefix";
    static final String TITLE_POST_FIX_KEY = ".title";
    private Map<String, String> keyUrlMap;
    private final I18nBeanFactory i18nBeanFactory;

    @Inject
    public DefaultDocumentationLinkProvider(I18nBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @PostConstruct
    @VisibleForTesting
    public void postConstruct() {
        this.keyUrlMap = ImmutableMap.builder().putAll(Collections.list(this.getI18nBean().getHelpPathsBundle().getKeys()).stream().collect(Collectors.toMap(Function.identity(), this::getUrl))).build();
    }

    @NotNull
    public String getUrl(@NotNull String key) {
        I18nBean i18nBean = this.getI18nBean();
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)"embedded.crowd.support.")) {
            return this.getLink("help.embedded.crowd.support.prefix", key, i18nBean);
        }
        return this.getLink(DOC_ROOT_KEY, key, i18nBean);
    }

    @NotNull
    private String getLink(String urlPrefixKey, @NotNull String linkKey, I18nBean i18nBean) {
        return this.getI18nText(i18nBean, urlPrefixKey).map(documentationRoot -> this.getI18nText(i18nBean, linkKey).map(documentationPath -> documentationRoot + documentationPath).orElse("")).orElse("");
    }

    @NotNull
    public String getTitle(@NotNull String key) {
        return this.getI18nText(this.getI18nBean(), key + TITLE_POST_FIX_KEY).orElse("");
    }

    @NotNull
    public Map<String, String> getAllUrls() {
        return this.keyUrlMap;
    }

    private Optional<String> getI18nText(I18nBean i18nBean, @NotNull String key) {
        String resolvedText = i18nBean.getText(key);
        if (StringUtils.isEmpty((CharSequence)resolvedText) || Objects.equals(resolvedText, key)) {
            return Optional.empty();
        }
        return Optional.of(resolvedText);
    }

    private I18nBean getI18nBean() {
        return this.i18nBeanFactory.getI18nBean();
    }
}

