/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.i18n;

import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultI18nBean
implements I18nBean,
Serializable {
    private static final Logger log = Logger.getLogger(DefaultI18nBean.class);
    private static final String DEFAULT_RESOURCE_BUNDLE = "com.atlassian.bamboo.ww2.BambooActionSupport";
    private static final String DEFAULT_HELP_PATHS_BUNDLE = "help-paths";
    private static final String DEFAULT_HELP_INTERNAL_BUNDLE = "help-internal";
    private static final String HIGHLIGHT = "bamboo.i18n.highlight";
    private static final String SHOWKEY = "bamboo.i18n.showkey";
    private static final String I18N = "i18n";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static boolean HIGHLIGHT_FLAG = false;
    private static boolean SHOWKEY_FLAG = false;
    private final List<ResourceBundle> i18nBundles = new ArrayList<ResourceBundle>();
    private Locale locale;
    private PluginAccessor pluginAccessor;

    public DefaultI18nBean(@NotNull Locale locale, @NotNull PluginAccessor pluginAccessor) {
        this.locale = locale;
        this.pluginAccessor = pluginAccessor;
        this.i18nBundles.add(this.getDefaultResourceBundle(DEFAULT_RESOURCE_BUNDLE));
        this.i18nBundles.add(this.getDefaultResourceBundle(DEFAULT_HELP_PATHS_BUNDLE));
        this.i18nBundles.add(this.getDefaultResourceBundle(DEFAULT_HELP_INTERNAL_BUNDLE));
        this.i18nBundles.add(this.getDefaultResourceBundle("com.atlassian.core.AtlassianCore"));
        this.i18nBundles.addAll(this.getPluginBundles(this.getPluginAccessor(), locale));
    }

    public boolean hasKey(String key) {
        return this.getTextRaw(key) != null;
    }

    public String getText(@NotNull String key) {
        return this.getText(key, key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getText(@NotNull String key, String defaultValue) {
        String textRaw = this.getTextRaw(key);
        if (textRaw == null) {
            return defaultValue;
        }
        try {
            return MessageFormat.format(textRaw, EMPTY_ARRAY);
        }
        catch (IllegalArgumentException e) {
            return textRaw;
        }
    }

    public String getI18nRawText(String key) {
        return this.getTextRaw(key);
    }

    public String getRawText(Locale locale, String key) {
        if (this.locale.equals(locale)) {
            return this.getTextRaw(key);
        }
        log.debug((Object)("Locale " + this.locale + " doesn't match " + locale));
        return key;
    }

    public String getText(String key, String defaultValue, String arg) {
        return this.getText(key, key, Arrays.asList(arg));
    }

    public String getText(String key, List args) {
        return this.getText(key, key, args);
    }

    public String getText(String key, Object[] args) {
        return this.getText(key, key, args);
    }

    public String getText(String key, String defaultValue, List args) {
        return this.getText(key, defaultValue, args != null ? args.toArray() : new Object[]{});
    }

    public String getText(String key, String defaultValue, Object[] args) {
        String result = this.getTextRaw(key);
        if (result == null) {
            return defaultValue;
        }
        try {
            return MessageFormat.format(result, args);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)("Error formatting internationalized string with key: " + key), (Throwable)ex);
            return defaultValue;
        }
    }

    @NotNull
    public Map<String, String> getAllTranslationsForPrefix(@NotNull String prefix) {
        HashMap<String, String> translations = new HashMap<String, String>();
        for (ResourceBundle bundle : this.getI18nBundles()) {
            Enumeration<String> i18nKeys = bundle.getKeys();
            while (i18nKeys.hasMoreElements()) {
                String i18nKey = i18nKeys.nextElement();
                if (!i18nKey.startsWith(prefix)) continue;
                translations.put(i18nKey, bundle.getString(i18nKey));
            }
        }
        return translations;
    }

    public ResourceBundle getDefaultResourceBundle() {
        return this.getDefaultResourceBundle(DEFAULT_RESOURCE_BUNDLE);
    }

    public ResourceBundle getHelpPathsBundle() {
        return this.getDefaultResourceBundle(DEFAULT_HELP_PATHS_BUNDLE);
    }

    @VisibleForTesting
    ResourceBundle getDefaultResourceBundle(String resourceBundleName) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(Thread.currentThread().getContextClassLoader());
        loaders.add(this.getClass().getClassLoader());
        for (ClassLoader loader : loaders) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, this.locale, loader);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        throw new MissingResourceException("Unable to load resource " + resourceBundleName + " for " + this.locale, resourceBundleName, this.locale.toString());
    }

    @NotNull
    private String highlightText(String key, String value) {
        String prefix = (this.isI18nHighlightMode() ? "[" : "") + (this.isI18nShowKeyMode() ? key + ":" : "");
        String postfix = this.isI18nHighlightMode() ? "]" : "";
        return prefix + value + postfix;
    }

    @NotNull
    private Collection<ResourceDescriptor> getResourceBundleLocations(@NotNull Plugin plugin) {
        ArrayList<ResourceDescriptor> locations = new ArrayList<ResourceDescriptor>();
        locations.addAll(plugin.getResourceDescriptors(I18N));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            locations.addAll(moduleDescriptor.getResourceDescriptors(I18N));
        }
        return locations;
    }

    @NotNull
    private Collection<? extends ResourceBundle> getPluginBundles(@NotNull Plugin plugin, Locale locale) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (ResourceDescriptor resourceDescriptor : this.getResourceBundleLocations(plugin)) {
            try {
                bundles.add(ResourceBundle.getBundle(resourceDescriptor.getLocation(), locale, plugin.getClassLoader()));
            }
            catch (RuntimeException ex) {
                log.error((Object)("Unable to load resource named [" + resourceDescriptor.getName() + "] of type [" + resourceDescriptor.getType() + "] located at [" + resourceDescriptor.getLocation() + "] defined in plugin [" + plugin.getKey() + "]"));
            }
        }
        return bundles;
    }

    @NotNull
    private Collection<? extends ResourceBundle> getPluginBundles(@NotNull PluginAccessor pluginAccessor, Locale locale) {
        ArrayList<? extends ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
            bundles.addAll(this.getPluginBundles(plugin, locale));
        }
        return bundles;
    }

    @Nullable
    @VisibleForTesting
    String getTextRaw(@NotNull String key) {
        if (key.startsWith("'") && key.endsWith("'")) {
            key = key.substring(1, key.length() - 1);
        }
        for (ResourceBundle bundle : this.getI18nBundles()) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Error getting text for key: (" + key + ") against resource bundle: (" + bundle + ") for locale: (" + this.locale + ")"), (Throwable)e);
            }
        }
        log.debug((Object)("Error getting text for key: (" + key + ")"));
        return null;
    }

    public List<ResourceBundle> getI18nBundles() {
        return this.i18nBundles;
    }

    private boolean isI18nHighlightMode() {
        return HIGHLIGHT_FLAG;
    }

    private boolean isI18nShowKeyMode() {
        return SHOWKEY_FLAG;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    static {
        HIGHLIGHT_FLAG = Boolean.getBoolean(HIGHLIGHT);
        SHOWKEY_FLAG = Boolean.getBoolean(SHOWKEY);
    }
}

