/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.i18n;

import com.atlassian.bamboo.utils.i18n.DefaultI18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;

public class I18nBeanFactoryImpl
implements I18nBeanFactory {
    private static final String CACHE_KEY_I18N = I18nBeanFactoryImpl.class.getName();
    private final CacheFactory cacheFactory;
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final PluginEventManager pluginEventManager;

    public I18nBeanFactoryImpl(@NotNull CacheFactory cacheFactory, @NotNull PluginAccessor pluginAccessor, @NotNull PluginEventManager pluginEventManager) {
        this.cacheFactory = cacheFactory;
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
    }

    @PostConstruct
    public void postConstruct() {
        this.pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.clearCache();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.clearCache();
    }

    public I18nBean getI18nBean() {
        return this.getI18nBean(Locale.getDefault());
    }

    public I18nBean getI18nBean(Locale locale) {
        Cache<Locale, I18nBean> cache = this.getCache();
        I18nBean i18nBean = (I18nBean)cache.get((Object)locale);
        if (i18nBean != null) {
            return i18nBean;
        }
        cache.putIfAbsent((Object)locale, (Object)new DefaultI18nBean(locale, this.pluginAccessor));
        return (I18nBean)cache.get((Object)locale);
    }

    private Cache<Locale, I18nBean> getCache() {
        return this.cacheFactory.getCache(CACHE_KEY_I18N);
    }

    private void clearCache() {
        Cache<Locale, I18nBean> cache = this.getCache();
        new ArrayList<Locale>(cache.getKeys()).forEach(arg_0 -> cache.remove(arg_0));
    }
}

