/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.jetbrains.annotations.NotNull;

public class HttpServletRequestMatcher
extends TypeSafeDiagnosingMatcher<HttpServletRequest> {
    private static final Logger log = Logger.getLogger(HttpServletRequestMatcher.class);
    @NotNull
    private final Matcher<? super String> servletPathMatcher;
    @NotNull
    private final Matcher<? super String> pathInfoMatcher;

    private HttpServletRequestMatcher(@NotNull Matcher<? super String> servletPathMatcher, @NotNull Matcher<? super String> pathInfoMatcher) {
        this.servletPathMatcher = servletPathMatcher;
        this.pathInfoMatcher = pathInfoMatcher;
    }

    protected boolean matchesSafely(HttpServletRequest item, Description mismatchDescription) {
        if (this.servletPathMatcher.matches((Object)item.getServletPath())) {
            if (this.pathInfoMatcher.matches((Object)item.getPathInfo())) {
                return true;
            }
            this.pathInfoMatcher.describeMismatch((Object)item.getPathInfo(), mismatchDescription);
        } else {
            this.servletPathMatcher.describeMismatch((Object)item.getServletPath(), mismatchDescription);
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.servletPathMatcher).appendDescriptionOf(this.pathInfoMatcher);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Matcher<? super String> servletPathMatcher = CoreMatchers.anything();
        private Matcher<? super String> pathInfoMatcher = CoreMatchers.anything();

        public Builder servletPath(@NotNull String servletPath) {
            return this.servletPath((Matcher<? super String>)CoreMatchers.equalTo((Object)servletPath));
        }

        public Builder servletPath(@NotNull Matcher<? super String> servletPathMatcher) {
            this.servletPathMatcher = servletPathMatcher;
            return this;
        }

        public Builder pathInfo(@NotNull String pathInfo) {
            return this.pathInfo((Matcher<? super String>)CoreMatchers.equalTo((Object)pathInfo));
        }

        public Builder pathInfo(@NotNull Matcher<? super String> pathInfoMatcher) {
            this.pathInfoMatcher = pathInfoMatcher;
            return this;
        }

        public HttpServletRequestMatcher build() {
            return new HttpServletRequestMatcher(this.servletPathMatcher, this.pathInfoMatcher);
        }
    }
}

