/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plugin.PluginInjectionHelper;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildConfigurationAwarePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseBuildConfigurationAwarePlugin
implements BuildConfigurationAwarePlugin {
    private static final Logger log = Logger.getLogger(BaseBuildConfigurationAwarePlugin.class);
    @Deprecated
    protected TemplateRenderer templateRenderer;
    protected ModuleDescriptor moduleDescriptor;
    @Inject
    private Optional<TemplateRenderer> templateRendererInternal;

    @PostConstruct
    private void postConstruct() {
        this.templateRenderer = (TemplateRenderer)PluginInjectionHelper.firstNotNull(this.templateRenderer, this.templateRendererInternal);
    }

    public void init(@NotNull ModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        return new SimpleErrorCollection();
    }

    @Nullable
    public String getViewHtml(@NotNull Plan plan) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", "view");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("plugin", this);
            context.put("build", plan);
            context.put("plan", plan);
            this.populateContextForView(context, plan);
            return this.templateRenderer.render(templatePath, context);
        }
        return "";
    }

    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
    }

    @Nullable
    public String getEditHtml(@NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("plugin", this);
            context.put("build", plan);
            context.put("plan", plan);
            context.put("buildConfiguration", buildConfiguration);
            this.populateContextForEdit(context, buildConfiguration, plan);
            return this.templateRenderer.render(templatePath, context);
        }
        return "";
    }

    protected void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
    }

    @Deprecated
    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

