/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildChangesImpl
implements BuildChanges {
    private static final Logger log = Logger.getLogger(BuildChangesImpl.class);
    private final FinalHashMap<Long, BuildRepositoryChanges> buildRepositoryChangesMap = new FinalHashMap();
    private long integrationRepositoryId;
    private PlanVcsRevisionData integrationBranchRevision;

    public BuildChangesImpl(@NotNull BuildChanges other) {
        for (BuildRepositoryChanges buildRepositoryChanges : other.getRepositoryChanges()) {
            this.addRepositoryChanges(new BuildRepositoryChangesImpl(buildRepositoryChanges));
        }
        PlanVcsRevisionData integrationBranchVcsRevision = other.getIntegrationBranchRevisionData();
        if (integrationBranchVcsRevision != null) {
            this.integrationBranchRevision = new PlanVcsRevisionData(integrationBranchVcsRevision.getVcsRevisionKey(), integrationBranchVcsRevision.getCustomXmlData(), integrationBranchVcsRevision.getActualBranch());
        }
        this.integrationRepositoryId = other.getIntegrationRepositoryId();
    }

    public BuildChangesImpl() {
    }

    public void addRepositoryChanges(@NotNull BuildRepositoryChanges repositoryChanges) {
        this.buildRepositoryChangesMap.put((Object)repositoryChanges.getRepositoryId(), (Object)repositoryChanges);
    }

    public Iterable<BuildRepositoryChanges> getRepositoryChanges() {
        return this.buildRepositoryChangesMap.values();
    }

    @Nullable
    public String getVcsRevisionKey(long repositoryId) {
        return this.getBuildRepositoryChanges(repositoryId).getVcsRevisionKey();
    }

    public void setVcsRevisionKey(long repositoryId, @NotNull String vcsRevisionKey) {
        this.getBuildRepositoryChanges(repositoryId).setVcsRevisionKey(vcsRevisionKey);
    }

    @NotNull
    public PlanVcsRevisionData getVcsRevisionData(long repositoryId) {
        BuildRepositoryChanges buildRepositoryChanges = this.getBuildRepositoryChanges(repositoryId);
        return new PlanVcsRevisionData(buildRepositoryChanges);
    }

    public String getPreviousVcsRevisionKey(long repositoryId) {
        return this.getBuildRepositoryChanges(repositoryId).getPreviousVcsRevisionKey();
    }

    public void setPreviousVcsRevisionKey(long repositoryId, @Nullable String previousVcsRevisionKey) {
        this.getBuildRepositoryChanges(repositoryId).setPreviousVcsRevisionKey(previousVcsRevisionKey);
    }

    public String getVcsLastChangeRevisionKey(long repositoryId) {
        return null;
    }

    public void setVcsLastChangeRevisionKey(long repositoryId, String vcsLastChangeRevisionKey) {
    }

    @NotNull
    public List<CommitContext> getChanges(long repositoryId) {
        return this.getBuildRepositoryChanges(repositoryId).getChanges();
    }

    @NotNull
    public ImmutableList<CommitContext> getChanges() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BuildRepositoryChanges buildRepositoryChanges : this.buildRepositoryChangesMap.values()) {
            builder.addAll((Iterable)buildRepositoryChanges.getChanges());
        }
        return builder.build();
    }

    public void setChanges(long repositoryId, @NotNull List<CommitContext> changes) {
        this.getBuildRepositoryChanges(repositoryId).setChanges(changes);
    }

    public int getSkippedCommitsCount(long repositoryId) {
        return this.getBuildRepositoryChanges(repositoryId).getSkippedCommitsCount();
    }

    public void setSkippedCommitsCount(long repositoryId, int skippedCommitsCount) {
        this.getBuildRepositoryChanges(repositoryId).setSkippedCommitsCount(skippedCommitsCount);
    }

    public String getIntegrationBranchVcsRevision() {
        return this.integrationBranchRevision.getVcsRevisionKey();
    }

    public long getIntegrationRepositoryId() {
        return this.integrationRepositoryId;
    }

    public void setIntegrationRepositoryId(long integrationRepositoryId) {
        this.integrationRepositoryId = integrationRepositoryId;
    }

    @Nullable
    public PlanVcsRevisionData getIntegrationBranchRevisionData() {
        return this.integrationBranchRevision;
    }

    public void setIntegrationBranchRevisionData(@NotNull PlanVcsRevisionData integrationBranchRevisionData) {
        this.integrationBranchRevision = integrationBranchRevisionData;
    }

    public int hashCode() {
        return new HashCodeBuilder(151, 5).append(this.buildRepositoryChangesMap).append((Object)this.integrationBranchRevision).append(this.integrationRepositoryId).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildChangesImpl)) {
            return false;
        }
        BuildChangesImpl rhs = (BuildChangesImpl)o;
        return new EqualsBuilder().append(this.buildRepositoryChangesMap, rhs.buildRepositoryChangesMap).append((Object)this.integrationBranchRevision, (Object)rhs.integrationBranchRevision).append(this.integrationRepositoryId, rhs.integrationRepositoryId).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.buildRepositoryChangesMap).append((Object)this.integrationBranchRevision).append(this.integrationRepositoryId).toString();
    }

    @NotNull
    public BuildRepositoryChanges getBuildRepositoryChanges(long repositoryId) {
        BuildRepositoryChanges buildRepositoryChanges = (BuildRepositoryChanges)this.buildRepositoryChangesMap.get((Object)repositoryId);
        if (buildRepositoryChanges == null) {
            throw new IllegalArgumentException("Unknown RepositoryDefinition " + repositoryId);
        }
        return buildRepositoryChanges;
    }
}

