/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersFunctions;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class BuildContextHelper {
    public static final String BUILD_WORKING_DIRECTORY = "working.directory";
    @Deprecated
    public static final String BUILD_WORKING_DIRECTORY_OLD = "build.working.directory";

    private BuildContextHelper() {
    }

    public static void rewire(BuildContext buildContext) {
        BuildDefinition buildDefinition = buildContext.getBuildDefinition();
        ContainerManager.autowireComponent((Object)buildDefinition);
    }

    @Deprecated
    @Nullable
    public static RepositoryDefinition getDefaultRepositoryDefinition(BuildContext buildContext) {
        return buildContext.getRepositoryDefinitions().stream().filter(r -> r.getPosition() == 0).findFirst().orElse(null);
    }

    @Nullable
    public static PlanRepositoryDefinition getDefaultPlanRepositoryDefinition(BuildContext buildContext) {
        return (PlanRepositoryDefinition)Iterables.getFirst((Iterable)buildContext.getVcsRepositories(), null);
    }

    public static File getBuildWorkingDirectory(CommonContext buildContext) {
        return new File((String)buildContext.getCurrentResult().getCustomBuildData().get(BUILD_WORKING_DIRECTORY));
    }

    @Deprecated
    public static File getBuildWorkingDirectory(BuildContext buildContext) {
        return new File((String)buildContext.getCurrentResult().getCustomBuildData().get(BUILD_WORKING_DIRECTORY));
    }

    @NotNull
    public static BuildContext getTopLevelBuildContext(@NotNull BuildContext initialBuildContext) {
        Preconditions.checkNotNull((Object)initialBuildContext);
        BuildContext buildContext = initialBuildContext;
        while (buildContext.getParentBuildContext() != null) {
            buildContext = buildContext.getParentBuildContext();
        }
        return buildContext;
    }

    private static Map<String, String> getArtifactHandlerConfigurationForBuildContext(@NotNull BuildContext buildContext) {
        HashMap<String, String> completeConfiguration = new HashMap<String, String>(buildContext.getArtifactContext().getArtifactHandlerConfiguration());
        BuildContext planBuildContext = BuildContextHelper.getTopLevelBuildContext(buildContext);
        BuildDefinition buildDefinition = planBuildContext.getBuildDefinition();
        BuildContextHelper.applyBuildDefinitionOverrides(completeConfiguration, buildDefinition);
        return completeConfiguration;
    }

    public static void applyBuildDefinitionOverrides(Map<String, String> completeConfiguration, BuildDefinition buildDefinition) {
        Map planCustomConfiguration = buildDefinition.getCustomConfiguration();
        if (ArtifactHandlingUtils.isCustomArtifactHandlingConfigured(planCustomConfiguration)) {
            Iterables.removeIf(completeConfiguration.keySet(), ArtifactHandlersFunctions::isArtifactHandlerOnOffSwitch);
            Map planLevelConfiguration = Maps.filterKeys((Map)planCustomConfiguration, ArtifactHandlersFunctions::isArtifactHandlerConfiguration);
            completeConfiguration.putAll(planLevelConfiguration);
        }
    }

    public static Map<String, String> getArtifactHandlerConfiguration(@NotNull CommonContext context) {
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)context, BuildContext.class);
        if (buildContext != null) {
            return BuildContextHelper.getArtifactHandlerConfigurationForBuildContext(buildContext);
        }
        if (context instanceof DeploymentContext) {
            return ((DeploymentContext)context).getArtifactHandlerConfiguration();
        }
        throw new IllegalArgumentException("Unhandled context class: " + context.getClass().getName());
    }
}

