/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.DefaultBuildDefinition;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.collections.message.FinalLinkedHashMap;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinitionImpl;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.BuildIdentifierImpl;
import com.atlassian.bamboo.v2.build.BuildKey;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.CurrentBuildResultImpl;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildContextImpl
extends BuildIdentifierImpl
implements BuildContext {
    private final BuildKey buildKey;
    private final String displayName;
    private final BuildContext parentBuildContext;
    private final TriggerReason triggerReason;
    private final BuildDefinition buildDefinition;
    private final ArtifactContext artifactContext;
    private VariableContext variableContext;
    private final FinalArrayList<CredentialsData> relevantSharedCredentials;
    private final FinalHashMap<PlanKey, ChainStorageTag> relevantStorageTags;
    private transient Map<Long, RepositoryDefinition> legacyRepositoryDefinitionMap;
    private final FinalLinkedHashMap<Long, PlanRepositoryDefinition> planRepositoryDefinitionMap;
    private final FinalHashSet<Long> relevantRepositoryIds;
    private final FinalHashMap<Long, String> checkoutLocation;
    private final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
    private final CurrentBuildResult currentBuildResult = new CurrentBuildResultImpl();
    private final boolean isBranch;
    private final boolean isOnceOff;
    private final boolean isCustomBuild;
    private final BambooBandanaContext bandanaContext;
    private final FinalArrayList<RuntimeTaskDefinition> runtimeTaskDefinitions;
    private volatile BuildChanges buildChanges;
    private final DockerPipelineConfiguration dockerPipelineConfiguration;
    private final long maximumWarningCount = SystemProperty.BUILD_WARNINGS_MAXIMUM_COUNT_PER_BUILD.getTypedValue();

    public BuildContextImpl(BuildIdentifier identifier, TriggerReason triggerReason, BuildDefinition buildDefinition, @Nullable BuildChanges buildChanges, BuildContext parentBuildContext, @Nullable ArtifactContext artifactContext, VariableContext variableContext, @Nullable Map<String, String> customBuildData, Map<Long, PlanRepositoryDefinition> planRepositoryDefinitionMap, Set<Long> relevantRepositoryIds, Map<Long, String> checkoutLocation, boolean isBranch, boolean isOnceOff, boolean isCustomBuild, BambooBandanaContext bandanaContext, @NotNull Iterable<CredentialsData> relevantSharedCredentials, @NotNull Map<PlanKey, ChainStorageTag> relevantStorageTags, BuildKey buildKey) {
        super(identifier);
        this.triggerReason = triggerReason;
        this.buildDefinition = new DefaultBuildDefinition(buildDefinition);
        this.artifactContext = artifactContext;
        this.variableContext = variableContext;
        this.buildChanges = buildChanges != null ? buildChanges : new BuildChangesImpl();
        this.parentBuildContext = parentBuildContext;
        if (customBuildData != null) {
            this.currentBuildResult.getCustomBuildData().putAll(customBuildData);
        }
        this.planRepositoryDefinitionMap = new FinalLinkedHashMap(planRepositoryDefinitionMap);
        this.relevantRepositoryIds = new FinalHashSet(relevantRepositoryIds);
        this.checkoutLocation = new FinalHashMap(checkoutLocation);
        this.isBranch = isBranch;
        this.isOnceOff = isOnceOff;
        this.isCustomBuild = isCustomBuild;
        this.bandanaContext = bandanaContext;
        this.displayName = identifier.getPlanName() + " #" + identifier.getBuildNumber() + " (" + identifier.getBuildResultKey() + ")";
        this.relevantSharedCredentials = new FinalArrayList(relevantSharedCredentials);
        this.relevantStorageTags = new FinalHashMap(relevantStorageTags);
        this.runtimeTaskDefinitions = buildDefinition == null ? new FinalArrayList() : buildDefinition.getTaskDefinitions().stream().map(RuntimeTaskDefinitionImpl::new).collect(Collectors.toCollection(FinalArrayList::new));
        this.buildKey = buildKey;
        DockerPipelineConfigurationImpl dockerPipelineConfigurationImpl = this.dockerPipelineConfiguration = buildDefinition != null && buildDefinition.getDockerPipelineConfiguration() != null ? new DockerPipelineConfigurationImpl(buildDefinition.getDockerPipelineConfiguration()) : new DockerPipelineConfigurationImpl();
        if (SystemProperty.DOCKER_PIPELINES_DISABLED.getTypedValue()) {
            this.dockerPipelineConfiguration.setEnabled(false);
        }
    }

    @NotNull
    public BuildKey getBuildKey() {
        return this.buildKey;
    }

    @Override
    public BuildIdentifier getParentBuildIdentifier() {
        return this.parentBuildContext;
    }

    public BuildContext getParentBuildContext() {
        return this.parentBuildContext;
    }

    @NotNull
    public TriggerReason getTriggerReason() {
        return this.triggerReason;
    }

    @NotNull
    public BuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    @NotNull
    public BuildChanges getBuildChanges() {
        return this.buildChanges;
    }

    public void setBuildChanges(BuildChanges buildChanges) {
        this.buildChanges = (BuildChanges)Preconditions.checkNotNull((Object)buildChanges);
    }

    @NotNull
    public CurrentBuildResult getBuildResult() {
        return this.currentBuildResult;
    }

    @NotNull
    public CurrentResult getCurrentResult() {
        return this.currentBuildResult;
    }

    @NotNull
    public ArtifactContext getArtifactContext() {
        return this.artifactContext;
    }

    @NotNull
    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    @NotNull
    public Map<Long, RepositoryDefinition> getRepositoryDefinitionMap() {
        if (this.legacyRepositoryDefinitionMap == null) {
            this.legacyRepositoryDefinitionMap = this.planRepositoryDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RepositoryDefinitionImpl((PlanRepositoryDefinition)e.getValue())));
        }
        return this.legacyRepositoryDefinitionMap;
    }

    @NotNull
    public List<RepositoryDefinition> getRepositoryDefinitions() {
        return ImmutableList.copyOf(this.getRepositoryDefinitionMap().values());
    }

    @NotNull
    public List<PlanRepositoryDefinition> getVcsRepositories() {
        return ImmutableList.copyOf((Collection)this.planRepositoryDefinitionMap.values());
    }

    @NotNull
    public Map<Long, PlanRepositoryDefinition> getVcsRepositoryMap() {
        return this.planRepositoryDefinitionMap;
    }

    @NotNull
    public Map<Long, String> getCheckoutLocation() {
        return this.checkoutLocation;
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public boolean isOnceOff() {
        return this.isOnceOff;
    }

    public boolean isCustomBuild() {
        return this.isCustomBuild;
    }

    @NotNull
    public BambooBandanaContext getBandanaContext() {
        return this.bandanaContext;
    }

    @NotNull
    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    public void setRelevantRepositories(@NotNull Set<RepositoryDefinition> relevantRepositories) {
        this.relevantRepositoryIds.clear();
        relevantRepositories.forEach(repo -> this.relevantRepositoryIds.add((Object)repo.getId()));
    }

    @NotNull
    public Set<Long> getRelevantRepositoryIds() {
        return this.relevantRepositoryIds;
    }

    public Key getEntityKey() {
        return this.getPlanResultKey().getPlanKey();
    }

    public ResultKey getResultKey() {
        return this.getPlanResultKey();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public List<TaskDefinition> getTaskDefinitions() {
        return ImmutableList.copyOf(this.runtimeTaskDefinitions);
    }

    @NotNull
    public List<RuntimeTaskDefinition> getRuntimeTaskDefinitions() {
        return this.runtimeTaskDefinitions;
    }

    public long getEntityId() {
        return this.getPlanDbId().orElseGet(() -> this.getMasterPlanId().orElseThrow(IllegalStateException::new));
    }

    @NotNull
    public Iterable<CredentialsData> getSharedCredentials() {
        return Collections.unmodifiableCollection(this.relevantSharedCredentials);
    }

    @NotNull
    public Map<PlanKey, ChainStorageTag> getChainStorageTags() {
        return this.relevantStorageTags;
    }

    public void setVariableContext(VariableContext variableContext) {
        this.variableContext = variableContext;
    }

    public Long getEntityGroupId() {
        return null;
    }

    @NotNull
    public DockerPipelineConfiguration getDockerPipelineConfiguration() {
        return this.dockerPipelineConfiguration;
    }

    public long getMaximumBuildWarningsCount() {
        return this.maximumWarningCount;
    }
}

