/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class BuildIdentifierImpl
implements BuildIdentifier {
    private final Long planId;
    private final Long masterPlanId;
    private final String planName;
    private final String shortName;
    private final PlanResultKey planResultKey;
    private final BuildIdentifier parentBuildIdentifier;
    private final String projectName;

    public BuildIdentifierImpl(@NotNull BuildIdentifier buildIdentifier) {
        this.planId = buildIdentifier.getPlanDbId().orElse(null);
        this.masterPlanId = buildIdentifier.getMasterPlanId().orElse(null);
        this.projectName = buildIdentifier.getProjectName();
        this.planName = buildIdentifier.getPlanName();
        this.shortName = buildIdentifier.getShortName();
        this.planResultKey = buildIdentifier.getPlanResultKey();
        BuildIdentifier parentBuildIdentifier = buildIdentifier.getParentBuildIdentifier();
        this.parentBuildIdentifier = parentBuildIdentifier != null && !parentBuildIdentifier.equals(buildIdentifier) ? new BuildIdentifierImpl(parentBuildIdentifier) : null;
    }

    @Deprecated
    public BuildIdentifierImpl(long planId, String planKey, String projectName, String planName, String shortName, int buildNumber) {
        this(planId, null, planKey, projectName, planName, shortName, buildNumber);
    }

    public BuildIdentifierImpl(@Nullable Long planId, @Nullable Long masterPlanId, String planKey, String projectName, String planName, String shortName, int buildNumber) {
        this.planId = planId;
        this.masterPlanId = masterPlanId;
        this.projectName = projectName;
        this.planName = planName;
        this.shortName = shortName;
        this.planResultKey = PlanKeys.getPlanResultKey((String)planKey, (int)buildNumber);
        this.parentBuildIdentifier = null;
    }

    public BuildIdentifier getParentBuildIdentifier() {
        return this.parentBuildIdentifier;
    }

    public long getPlanId() {
        if (this.planId == null) {
            throw new IllegalStateException("Plan " + this.getPlanKey() + " does not exist in DB");
        }
        return this.planId;
    }

    public Optional<Long> getPlanDbId() {
        return Optional.ofNullable(this.planId);
    }

    public Optional<Long> getMasterPlanId() {
        return Optional.ofNullable(this.masterPlanId);
    }

    @NotNull
    public String getPlanKey() {
        return this.planResultKey.getPlanKey().getKey();
    }

    @NotNull
    public PlanKey getTypedPlanKey() {
        return this.planResultKey.getPlanKey();
    }

    @NotNull
    public String getPlanName() {
        return this.planName;
    }

    @NotNull
    public String getShortName() {
        return this.shortName;
    }

    public int getBuildNumber() {
        return this.planResultKey.getBuildNumber();
    }

    @NotNull
    public String getBuildResultKey() {
        return this.planResultKey.getKey();
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    @NotNull
    public String getProjectName() {
        return this.projectName;
    }

    public int hashCode() {
        return this.getPlanKey().hashCode() + this.getBuildNumber();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildIdentifier) {
            BuildIdentifier buildIdentifier = (BuildIdentifier)obj;
            return this.getPlanKey().equals(buildIdentifier.getPlanKey()) && this.getBuildNumber() == buildIdentifier.getBuildNumber();
        }
        return super.equals(obj);
    }
}

