/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.collections.message.FinalLinkedList;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.commit.CommitFunctions;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRepositoryChangesImpl
implements BuildRepositoryChanges {
    private static final Logger log = Logger.getLogger(BuildRepositoryChangesImpl.class);
    private long repositoryId;
    private String vcsRevisionKey;
    private String previousVcsRevisionKey;
    private FinalLinkedList<CommitContextImpl> changes;
    private int skippedCommitsCount;
    private boolean buildTrigger;
    private String customXmlData;
    private VcsBranchImpl actualBranch;

    public BuildRepositoryChangesImpl(@NotNull BuildRepositoryChanges other) {
        this(other.getRepositoryId(), other.getVcsRevisionKey(), null);
        this.setPreviousVcsRevisionKey(other.getPreviousVcsRevisionKey());
        this.setChanges(other.getChanges());
        this.setSkippedCommitsCount(other.getSkippedCommitsCount());
        this.buildTrigger = other.isBuildTrigger();
        this.customXmlData = other.getCustomXmlData();
        this.actualBranch = other.getActualBranch() != null ? new VcsBranchImpl(other.getActualBranch()) : null;
    }

    @Deprecated
    public BuildRepositoryChangesImpl() {
        this(-1L, null, null);
    }

    @Deprecated
    public BuildRepositoryChangesImpl(long repositoryId) {
        this(repositoryId, null, null);
    }

    @Deprecated
    public BuildRepositoryChangesImpl(@NotNull String vcsRevisionKey) {
        this(-1L, vcsRevisionKey, null);
    }

    @Deprecated
    public BuildRepositoryChangesImpl(@NotNull String vcsRevisionKey, @NotNull List<? extends CommitContext> changes) {
        this(-1L, vcsRevisionKey, changes);
    }

    @Deprecated
    public BuildRepositoryChangesImpl(long repositoryId, @Nullable String vcsRevisionKey, @Nullable List<? extends CommitContext> changes) {
        this(repositoryId, vcsRevisionKey, changes, null);
    }

    public BuildRepositoryChangesImpl(long repositoryId, @Nullable String vcsRevisionKey, @Nullable List<? extends CommitContext> changes, @Nullable VcsBranch actualBranch) {
        this.repositoryId = repositoryId;
        this.vcsRevisionKey = vcsRevisionKey;
        if (changes == null) {
            this.changes = new FinalLinkedList();
        } else {
            this.setChanges(changes);
        }
        this.actualBranch = actualBranch != null ? new VcsBranchImpl(actualBranch) : null;
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(long repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Nullable
    public String getVcsRevisionKey() {
        return this.vcsRevisionKey;
    }

    public void setVcsRevisionKey(@NotNull String vcsRevisionKey) {
        this.vcsRevisionKey = vcsRevisionKey;
    }

    @Nullable
    public String getPreviousVcsRevisionKey() {
        return this.previousVcsRevisionKey;
    }

    public void setPreviousVcsRevisionKey(@Nullable String previousVcsRevisionKey) {
        this.previousVcsRevisionKey = previousVcsRevisionKey;
    }

    public String getVcsLastChangeRevisionKey() {
        return null;
    }

    public void setVcsLastChangeRevisionKey(String vcsLastChangeRevisionKey) {
    }

    @NotNull
    public List<CommitContext> getChanges() {
        return this.changes;
    }

    public final void setChanges(@NotNull List<? extends CommitContext> changes) {
        this.changes = changes.stream().map(CommitFunctions::cloneCommit).collect(Collectors.toCollection(FinalLinkedList::new));
    }

    public int getSkippedCommitsCount() {
        return this.skippedCommitsCount;
    }

    public void setSkippedCommitsCount(int skippedCommitsCount) {
        this.skippedCommitsCount = skippedCommitsCount;
    }

    public String getCustomXmlData() {
        return this.customXmlData;
    }

    public void setCustomXmlData(@Nullable String customXmlData) {
        this.customXmlData = customXmlData;
    }

    public boolean isBuildTrigger() {
        return this.buildTrigger;
    }

    public void setBuildTrigger(boolean buildTrigger) {
        this.buildTrigger = buildTrigger;
    }

    @Nullable
    public VcsBranch getOverriddenVcsBranch() {
        return this.actualBranch;
    }

    public void setOverriddenVcsBranch(@NotNull VcsBranch overriddenVcsBranch) {
        this.actualBranch = new VcsBranchImpl(overriddenVcsBranch);
    }

    @Nullable
    public VcsBranch getActualBranch() {
        return this.actualBranch;
    }

    public void setActualBranch(@Nullable VcsBranch actualBranch) {
        this.actualBranch = actualBranch != null ? new VcsBranchImpl(actualBranch) : null;
    }

    public int hashCode() {
        return new HashCodeBuilder(151, 5).append((Object)this.getVcsRevisionKey()).append(this.getChanges()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildRepositoryChangesImpl)) {
            return false;
        }
        BuildRepositoryChangesImpl rhs = (BuildRepositoryChangesImpl)o;
        return new EqualsBuilder().append((Object)this.getVcsRevisionKey(), (Object)rhs.getVcsRevisionKey()).append(this.getChanges(), rhs.getChanges()).isEquals();
    }

    public int compareTo(BuildRepositoryChanges o) {
        return new CompareToBuilder().append((Object)this.getVcsRevisionKey(), (Object)o.getVcsRevisionKey()).append(this.getChanges(), (Object)o.getChanges()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getVcsRevisionKey()).append(this.getChanges()).toString();
    }
}

