/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalConcurrentHashMap;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.BuildResultsImpl;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentBuildResultImpl
implements CurrentBuildResult,
Serializable {
    private static final Logger log = Logger.getLogger(CurrentBuildResultImpl.class);
    private final FinalConcurrentHashMap<String, String> customBuildData;
    private BuildState buildState = BuildState.UNKNOWN;
    private LifeCycleState lifeCycleState = LifeCycleState.PENDING;
    private int buildReturnCode;
    private boolean started;
    private FinalArrayList<String> buildErrors;
    private FinalHashSet<TestResults> successfulTestResults;
    private FinalHashSet<TestResults> failedTestResults;
    private FinalHashSet<TestResults> skippedTestResults;
    private FinalArrayList<TaskResult> taskResults;
    private FinalHashSet<BuildWarningSummary> warnings;
    private boolean checkoutSuccess = false;
    private Date tasksStartDate = new Date();
    private AtomicInteger parserError = new AtomicInteger(0);
    private VcsWorkingCopyState vcsWorkingCopyState = new VcsWorkingCopyState();

    public CurrentBuildResultImpl() {
        this.customBuildData = new FinalConcurrentHashMap();
        this.buildErrors = new FinalArrayList();
        this.taskResults = new FinalArrayList();
        this.warnings = new FinalHashSet();
    }

    @NotNull
    public BuildState getBuildState() {
        return this.buildState;
    }

    public void setBuildState(@NotNull BuildState buildState) {
        this.buildState = buildState;
    }

    @NotNull
    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public void setLifeCycleState(@NotNull LifeCycleState lifeCycleState) {
        this.lifeCycleState = lifeCycleState;
    }

    @NotNull
    public Map<String, String> getCustomBuildData() {
        return this.customBuildData;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void addBuildErrors(@Nullable List<String> errorMessages) {
        if (errorMessages != null) {
            this.buildErrors.addAll(errorMessages);
        }
    }

    @NotNull
    public List<String> getBuildErrors() {
        return this.buildErrors;
    }

    @Deprecated
    public void setBuildErrors(@NotNull List<String> buildErrors) {
        this.buildErrors = new FinalArrayList(buildErrors);
    }

    public void clearBuildErrors() {
        this.buildErrors.clear();
    }

    @Nullable
    public Collection<TestResults> getFailedTestResults() {
        return this.failedTestResults;
    }

    @Nullable
    public Collection<TestResults> getSuccessfulTestResults() {
        return this.successfulTestResults;
    }

    @Nullable
    public Collection<TestResults> getSkippedTestResults() {
        return this.skippedTestResults;
    }

    public void setTestResults(@Nullable Set<TestResults> successfulTestResults, @Nullable Set<TestResults> failedTestResults, @Nullable Set<TestResults> skippedTestResults) {
        this.successfulTestResults = FinalHashSet.copyOf(successfulTestResults);
        this.failedTestResults = FinalHashSet.copyOf(failedTestResults);
        this.skippedTestResults = FinalHashSet.copyOf(skippedTestResults);
    }

    public void setTestResults(@Nullable Set<TestResults> successfulTestResults, @Nullable Set<TestResults> failedTestResults) {
        this.successfulTestResults = FinalHashSet.copyOf(successfulTestResults);
        this.failedTestResults = FinalHashSet.copyOf(failedTestResults);
    }

    public void appendTestResults(@Nullable Set<TestResults> successfulTestResults, @Nullable Set<TestResults> failedTestResults, @Nullable Set<TestResults> skippedTestResults) {
        this.successfulTestResults = this.appendTestResults(this.successfulTestResults, successfulTestResults);
        this.failedTestResults = this.appendTestResults(this.failedTestResults, failedTestResults);
        this.skippedTestResults = this.appendTestResults(this.skippedTestResults, skippedTestResults);
    }

    public BuildResults cloneAsBuildResults(BuildContext buildContext, ReasonForBuild reasonForBuild) {
        BuildResultsImpl buildResults = new BuildResultsImpl(buildContext.getPlanKey(), this.getBuildState(), this.getBuildErrors(), null, reasonForBuild);
        buildResults.setBuildNumber(buildContext.getBuildNumber());
        buildResults.setBuildChanges(buildContext.getBuildChanges());
        Map clonedCustomData = buildResults.getCustomBuildData();
        Map<String, String> customData = this.getCustomBuildData();
        for (Map.Entry<String, String> customDataEntry : customData.entrySet()) {
            clonedCustomData.put(customDataEntry.getKey(), customDataEntry.getValue());
        }
        return buildResults;
    }

    public int getBuildReturnCode() {
        return this.buildReturnCode;
    }

    public void setBuildReturnCode(int buildReturnCode) {
        this.buildReturnCode = buildReturnCode;
    }

    public boolean isCheckoutSuccess() {
        return this.checkoutSuccess;
    }

    public void setCheckoutSuccess(boolean checkoutSuccess) {
        this.checkoutSuccess = checkoutSuccess;
    }

    public void incParserErrorsCount(int count) {
        this.parserError.addAndGet(count);
    }

    public int getParserErrorsCount() {
        return this.parserError.get();
    }

    @NotNull
    public List<TaskResult> getTaskResults() {
        return this.taskResults;
    }

    public void setTaskResults(List<TaskResult> taskResults) {
        this.taskResults = new FinalArrayList(taskResults);
    }

    public List<TaskResult> getTaskResultsForTask(@NotNull String pluginKey) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.taskResults, BambooPredicates.isTaskResultPluginKeyEqual(pluginKey)));
    }

    @Nullable
    private FinalHashSet<TestResults> appendTestResults(@Nullable FinalHashSet<TestResults> existingResults, @Nullable Set<TestResults> newResults) {
        if (existingResults == null && newResults == null) {
            return null;
        }
        if (existingResults == null) {
            return new FinalHashSet(newResults);
        }
        if (newResults != null) {
            existingResults.addAll(newResults);
        }
        return existingResults;
    }

    @NotNull
    public Date getTasksStartDate() {
        return this.tasksStartDate;
    }

    public void setTasksStartDate(@NotNull Date taskStartDate) {
        this.tasksStartDate = taskStartDate;
    }

    public FinalHashSet<BuildWarningSummary> getBuildWarningSummaries() {
        return this.warnings;
    }

    public VcsWorkingCopyState getVcsWorkingCopyState() {
        return this.vcsWorkingCopyState;
    }
}

