/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalConcurrentHashMap;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyState;
import com.atlassian.collectors.CollectorsUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentResultImpl
implements CurrentResult {
    private final FinalConcurrentHashMap<String, String> customBuildData = new FinalConcurrentHashMap();
    private final FinalArrayList<String> buildErrors = new FinalArrayList();
    private BuildState buildState = BuildState.UNKNOWN;
    private LifeCycleState lifeCycleState = LifeCycleState.PENDING;
    private boolean started;
    private FinalArrayList<TaskResult> taskResults = new FinalArrayList();
    private Date tasksStartDate = new Date();
    private VcsWorkingCopyState vcsWorkingCopyState = new VcsWorkingCopyState();

    @NotNull
    public BuildState getBuildState() {
        return this.buildState;
    }

    public void setBuildState(@NotNull BuildState buildState) {
        this.buildState = buildState;
    }

    @NotNull
    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public void setLifeCycleState(@NotNull LifeCycleState lifeCycleState) {
        this.lifeCycleState = lifeCycleState;
    }

    @NotNull
    public Map<String, String> getCustomBuildData() {
        return this.customBuildData;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void addBuildErrors(@Nullable List<String> errorMessages) {
        if (errorMessages != null) {
            this.buildErrors.addAll(errorMessages);
        }
    }

    @NotNull
    public List<String> getBuildErrors() {
        return this.buildErrors;
    }

    public void clearBuildErrors() {
        this.buildErrors.clear();
    }

    @NotNull
    public List<TaskResult> getTaskResults() {
        return this.taskResults;
    }

    public void setTaskResults(List<TaskResult> taskResults) {
        this.taskResults = new FinalArrayList(taskResults);
    }

    public List<TaskResult> getTaskResultsForTask(@NotNull String pluginKey) {
        return (List)this.taskResults.stream().filter(arg_0 -> BambooPredicates.isTaskResultPluginKeyEqual(pluginKey).apply(arg_0)).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public Date getTasksStartDate() {
        return this.tasksStartDate;
    }

    public void setTasksStartDate(@NotNull Date startDate) {
        this.tasksStartDate = startDate;
    }

    public VcsWorkingCopyState getVcsWorkingCopyState() {
        return this.vcsWorkingCopyState;
    }
}

