/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.build.monitoring.BuildHungDetails;
import com.atlassian.bamboo.build.monitoring.BuildQueueTimeoutDetails;
import com.atlassian.bamboo.builder.BuildProgressBar;
import com.atlassian.bamboo.builder.BuildProgressBarImpl;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.BuildIdentifierImpl;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class CurrentlyBuildingImpl
implements CurrentlyBuilding {
    private static final Logger log = Logger.getLogger(CurrentlyBuildingImpl.class);
    private final BuildIdentifier buildIdentifier;
    private final BuildChanges buildChanges;
    private final TriggerReason triggerReason;
    private final Long averageDuration;
    private volatile Long buildAgentId;
    private final Date queueTime;
    private volatile Date vcsUpdateTime;
    private volatile Long startTime;
    private volatile Long stopTime;
    private volatile BuildHungDetails buildHungDetails;
    private volatile BuildCancelledDetails buildCancelledDetails;
    private volatile BuildQueueTimeoutDetails buildQueueTimeoutDetails;
    private final AtomicBoolean aboutToBeDestroyed = new AtomicBoolean();
    private final AtomicBoolean queuedOnly = new AtomicBoolean(true);
    @XStreamOmitField
    private BuildProgressBar buildProgressBar;

    public CurrentlyBuildingImpl(BuildIdentifier buildIdentifier, BuildChanges buildChanges, TriggerReason triggerReason, Long averageDuration) {
        this.buildIdentifier = new BuildIdentifierImpl(buildIdentifier);
        this.buildChanges = buildChanges;
        this.triggerReason = triggerReason;
        this.averageDuration = averageDuration;
        this.queueTime = new Date();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CurrentlyBuilding created for '" + buildIdentifier.getBuildResultKey() + "'"));
        }
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.buildIdentifier.getPlanResultKey();
    }

    @NotNull
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @NotNull
    public BuildChanges getBuildChanges() {
        return this.buildChanges;
    }

    @NotNull
    public TriggerReason getTriggerReason() {
        return this.triggerReason;
    }

    @NotNull
    public BuildProgressBar getProgressBar() {
        if (this.buildProgressBar == null) {
            this.buildProgressBar = new BuildProgressBarImpl((CurrentlyBuilding)this);
        }
        return this.buildProgressBar;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    public boolean tryToFinish() {
        return this.aboutToBeDestroyed.compareAndSet(false, true);
    }

    @Nullable
    public Long getBuildAgentId() {
        return this.buildAgentId;
    }

    public void setBuildAgentId(@Nullable Long buildAgentId) {
        this.buildAgentId = buildAgentId;
        this.queuedOnly.compareAndSet(true, buildAgentId == null);
    }

    public boolean isCurrentlyQueuedOnly() {
        return this.queuedOnly.get();
    }

    @Nullable
    public Date getStartTime() {
        if (this.startTime != null) {
            return new Date(this.startTime);
        }
        return null;
    }

    @NotNull
    public Date getQueueTime() {
        return this.queueTime;
    }

    @Nullable
    public Date getVcsUpdateTime() {
        return this.vcsUpdateTime;
    }

    public void setVcsUpdateTime(@NotNull Date vcsUpdateTime) {
        this.vcsUpdateTime = vcsUpdateTime;
    }

    public long getElapsedTime() {
        if (this.startTime == null) {
            return 0L;
        }
        if (this.stopTime == null) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public boolean isUpdatingVcs() {
        return this.vcsUpdateTime != null && this.startTime == null;
    }

    public void startTimer() {
        this.stopTime = null;
        this.startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        if (this.startTime == null) {
            log.warn((Object)String.format("%s: timer being stopped, but timer isn't started", this.getPlanResultKey()));
        }
        if (this.stopTime == null) {
            this.stopTime = System.currentTimeMillis();
        }
    }

    @Nullable
    public BuildHungDetails getBuildHangDetails() {
        return this.buildHungDetails;
    }

    public void setBuildHangDetails(@Nullable BuildHungDetails buildHungDetails) {
        this.buildHungDetails = buildHungDetails;
    }

    @Nullable
    public BuildCancelledDetails getBuildCancelledDetails() {
        return this.buildCancelledDetails;
    }

    public void setBuildCancelledDetails(@Nullable BuildCancelledDetails buildCancelledDetails) {
        this.buildCancelledDetails = buildCancelledDetails;
    }

    public BuildQueueTimeoutDetails getBuildQueueTimeoutDetails() {
        return this.buildQueueTimeoutDetails;
    }

    public void setBuildQueueTimeoutDetails(BuildQueueTimeoutDetails buildQueueTimeoutDetails) {
        this.buildQueueTimeoutDetails = buildQueueTimeoutDetails;
    }

    public int hashCode() {
        return new HashCodeBuilder(457, 23).append((Object)this.getPlanResultKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CurrentlyBuildingImpl)) {
            return false;
        }
        CurrentlyBuildingImpl rhs = (CurrentlyBuildingImpl)o;
        return new EqualsBuilder().append((Object)this.getPlanResultKey(), (Object)rhs.getPlanResultKey()).isEquals();
    }
}

