/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;

public class CustomBuildDataHelper {
    private static final Logger log = Logger.getLogger(CustomBuildDataHelper.class);
    @NonNls
    private static final String TOTAL = "total";

    public static void appendListValue(String keyPrefix, String value, Map<String, String> customBuildData) {
        String prefix = keyPrefix + ".";
        int maxIndex = -1;
        for (String key : customBuildData.keySet()) {
            String potentialIndex;
            if (!key.startsWith(prefix) || TOTAL.equals(potentialIndex = StringUtils.substringAfter((String)key, (String)prefix))) continue;
            try {
                int index = Integer.parseInt(potentialIndex);
                if (index <= maxIndex) continue;
                maxIndex = index;
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse '" + potentialIndex + "' for key '" + key + "'. Ignoring."));
            }
        }
        customBuildData.put(prefix + ++maxIndex, value);
        customBuildData.put(prefix + TOTAL, String.valueOf(maxIndex + 1));
    }

    public static long getStoredListTotal(String parent, Map<String, String> customBuildData) {
        return MapUtils.getIntValue(customBuildData, (Object)(parent + "." + TOTAL), (int)0);
    }

    public static Map<String, String> getSubset(String keyPref, Map<String, String> customBuildData) {
        return new HashMap<String, String>(Maps.filterKeys(customBuildData, TextPredicates.startsWith((String)keyPref)::test));
    }
}

