/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.HasSystemInfo;
import com.atlassian.bamboo.v2.build.agent.HasUuid;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@Internal
public final class BuildAgentFunctions {
    private BuildAgentFunctions() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static boolean isRemote(BuildAgent agent) {
        return agent.getDefinition() instanceof RemoteAgentDefinition;
    }

    public static boolean hasUuid(BuildAgent agent) {
        return agent instanceof HasUuid && ((HasUuid)HasUuid.class.cast(agent)).hasUuid();
    }

    public static boolean hasSystemInfo(BuildAgent agent) {
        return agent instanceof HasSystemInfo && ((HasSystemInfo)HasSystemInfo.class.cast(agent)).hasSystemInfo();
    }

    @Nullable
    public static UUID getUuid(BuildAgent agent) {
        if (BuildAgentFunctions.hasUuid(agent)) {
            return ((HasUuid)HasUuid.class.cast(agent)).getUuid();
        }
        return null;
    }

    @Nullable
    public static SystemInfo getSystemInfo(BuildAgent agent) {
        if (BuildAgentFunctions.hasSystemInfo(agent)) {
            return ((HasSystemInfo)HasSystemInfo.class.cast(agent)).getSystemInfo();
        }
        return null;
    }
}

