/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentCancellingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentOfflineStatus;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.HasSystemInfo;
import com.atlassian.bamboo.v2.build.agent.HasUuid;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildAgentImpl
implements BuildAgent,
HasUuid,
HasSystemInfo {
    private static final Logger log = Logger.getLogger(BuildAgentImpl.class);
    private static final Supplier<AgentAssignmentService> agentAssignmentService = () -> ComponentAccessor.AGENT_ASSIGNMENT_SERVICE.get();
    private volatile PipelineDefinition definition;
    private volatile AgentStatus agentStatusUseGetterToAccess;
    private volatile Date lastUpdated;
    private volatile Date remoteTimestamp;
    private volatile SystemInfo systemInfo;
    private volatile boolean requestedToBeStopped;
    private volatile boolean unresponsive;
    private volatile UUID uuid;
    private transient Supplier<String> agentType = new LazyReference<String>(){

        protected String create() {
            final AtomicReference agentType = new AtomicReference();
            BuildAgentImpl.this.definition.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    agentType.set("ELASTIC");
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                    agentType.set("LOCAL");
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    agentType.set("REMOTE");
                }
            });
            return (String)agentType.get();
        }
    };

    public BuildAgentImpl(@NotNull PipelineDefinition definition, @NotNull AgentStatus agentStatus) {
        this.definition = definition;
        this.agentStatusUseGetterToAccess = agentStatus;
    }

    protected BuildAgentImpl(LocalAgentDefinition definition) {
        this.definition = definition;
    }

    public long getId() {
        return this.definition.getId();
    }

    public String getName() {
        return this.definition.getName();
    }

    public AgentType getType() {
        return this.definition.getType();
    }

    public boolean isActive() {
        return !(this.getAgentStatus() instanceof AgentOfflineStatus);
    }

    public boolean isEnabled() {
        return this.definition.isEnabled();
    }

    @NotNull
    public AgentStatus getAgentStatus() {
        return this.agentStatusUseGetterToAccess;
    }

    public boolean isUnresponsive() {
        return this.unresponsive;
    }

    public void setUnresponsive(boolean unresponsive) {
        this.unresponsive = unresponsive;
    }

    public void setAgentStatus(@NotNull AgentStatus newAgentStatus) {
        if (!Objects.equals(this.getAgentStatus().getClass(), newAgentStatus.getClass())) {
            log.debug((Object)("Agent [" + this.getId() + "] transitioning from idle status " + this.getAgentStatus().isIdle() + " to idle status " + newAgentStatus.isIdle()));
        }
        this.agentStatusUseGetterToAccess = newAgentStatus;
    }

    public boolean isBusy() {
        AgentStatus status = this.getAgentStatus();
        return status instanceof AgentBuildingStatus || status instanceof AgentCancellingStatus;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Nullable
    public Date getRemoteTimestamp() {
        return this.remoteTimestamp;
    }

    public void setRemoteTimestamp(Date remoteTimestamp) {
        this.remoteTimestamp = remoteTimestamp;
    }

    @Override
    @Nullable
    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    @Override
    public boolean hasSystemInfo() {
        return this.systemInfo != null;
    }

    public void setSystemInfo(SystemInfo systemInfo) {
        this.systemInfo = systemInfo;
    }

    public boolean isRequestedToBeStopped() {
        return this.requestedToBeStopped;
    }

    public void setRequestedToBeStopped(boolean requestedToBeStopped) {
        this.requestedToBeStopped = requestedToBeStopped;
    }

    @NotNull
    public PipelineDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(@NotNull PipelineDefinition definition) {
        this.definition = definition;
    }

    public void accept(final BuildAgent.BuildAgentVisitor buildAgentVisitor) {
        this.definition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                buildAgentVisitor.visitRemote((BuildAgent)BuildAgentImpl.this);
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                buildAgentVisitor.visitLocal((LocalBuildAgent)BuildAgentImpl.this);
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                buildAgentVisitor.visitRemote((BuildAgent)BuildAgentImpl.this);
            }
        });
    }

    public boolean isDedicated() {
        return !agentAssignmentService.get().getAgentAssignments().forExecutors(AgentAssignmentServiceHelper.asExecutors((BuildAgent)this)).isEmpty();
    }

    public int hashCode() {
        return new HashCodeBuilder(643, 7).append((Object)this.getName()).append(this.getId()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildAgent)) {
            return false;
        }
        BuildAgent rhs = (BuildAgent)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append(this.getId(), rhs.getId()).isEquals();
    }

    public int compareTo(BuildAgent o) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)o.getName()).append(this.getId(), o.getId()).toComparison();
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ", " + this.agentType.get() + ", " + (this.isActive() ? "online" : "offline") + ", " + (this.isEnabled() ? "enabled" : "disabled") + ")";
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean hasUuid() {
        return this.uuid != null;
    }
}

