/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.v2.build.agent.HeartBeatCheckerJob;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class HeartBeatCheckerJobScheduler {
    private static final Logger log = Logger.getLogger(HeartBeatCheckerJobScheduler.class);
    private static final JobKey JOB_KEY = new JobKey("HeartBeatChecker", "HeartBeatChecker");
    private final int heartbeatCheckInterval;
    private Scheduler scheduler;

    public HeartBeatCheckerJobScheduler(int heartbeatCheckInterval) {
        this.heartbeatCheckInterval = heartbeatCheckInterval;
    }

    public void scheduleHeartBeatJob() throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(HeartBeatCheckerJob.class).withIdentity(JOB_KEY).build();
        log.info((Object)("Heartbeat checker job running every " + this.heartbeatCheckInterval + "s."));
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("HeartBeatChecker").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)this.heartbeatCheckInterval)).startNow().build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

