/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.plugin.descriptor.CapabilityTypeModuleDescriptor;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityTypeModule;
import com.atlassian.plugin.ModuleDescriptor;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCapabilityTypeModule
extends AbstractCapabilityType
implements CapabilityTypeModule {
    private int sortOrder = 0;
    private String capabilityTypeKey;
    private String capabilityTypeLabel;
    private String editTemplate;
    @Inject
    private transient Optional<TemplateRenderer> templateRenderer;

    public int getSortOrder() {
        return this.sortOrder;
    }

    @NotNull
    public String getCapabilityTypeKey() {
        if (this.capabilityTypeKey == null) {
            throw new IllegalStateException("CapabilityTypeKey not set for ");
        }
        return this.capabilityTypeKey;
    }

    @NotNull
    public String getCapabilityTypeLabel() {
        return this.capabilityTypeLabel != null ? this.capabilityTypeLabel : this.getCapabilityTypeKey();
    }

    public String getExtraInfo(@NotNull String key) {
        return null;
    }

    public String getValueDescriptionKey(@NotNull String key, @Nullable String value) {
        return null;
    }

    public boolean isAllowRename() {
        return false;
    }

    @NotNull
    public String getNewKeyFromLabel(@NotNull String oldKey, @NotNull String label) {
        String msg = this.isAllowRename() ? "CapabilityType must override this method if isAllowRename() is true." : "Method can only be called when key for this type can be renamed (isAllowRename() is true).";
        throw new UnsupportedOperationException(msg);
    }

    public String getEditHtml() {
        return this.templateRenderer.get().render(this.editTemplate, Collections.singletonMap("capabilityType", this));
    }

    public void init(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor instanceof CapabilityTypeModuleDescriptor) {
            CapabilityTypeModuleDescriptor descriptor = (CapabilityTypeModuleDescriptor)moduleDescriptor;
            this.capabilityTypeKey = moduleDescriptor.getKey();
            this.capabilityTypeLabel = moduleDescriptor.getName();
            this.sortOrder = descriptor.getSortOrder();
            this.editTemplate = descriptor.getEditTemplate();
        }
    }

    @Deprecated
    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = Optional.of(templateRenderer);
    }
}

