/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityTypeModule;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.core.i18n.I18nTextProvider;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExecutableCapabilityTypeModule
extends AbstractCapabilityTypeModule
implements CapabilityDefaultsHelper,
I18nTextProvider {
    private static final Logger log = Logger.getLogger(AbstractExecutableCapabilityTypeModule.class);
    protected static final String AGENT_CAPABILITY_TYPE_PREFIX = "agent.capability.type.";
    @Inject
    private Optional<TextProvider> textProvider;

    public abstract String getMandatoryCapabilityKey();

    public abstract String getExecutableKey();

    public abstract String getCapabilityUndefinedKey();

    public abstract List<String> getDefaultWindowPaths();

    public abstract String getExecutableFilename();

    @NotNull
    public String getLabel(@NotNull String key) {
        return this.getText(this.getMandatoryCapabilityKey());
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String executable = AbstractExecutableCapabilityTypeModule.getParamValue(params, this.getExecutableKey());
        BambooFieldValidate.checkFieldXssSafety(fieldErrors, (TextProvider)this.textProvider.orElse(null), this.getExecutableKey(), executable);
        if (this.getMandatoryCapabilityKey().equals(executable) && StringUtils.isEmpty((CharSequence)AbstractExecutableCapabilityTypeModule.getParamValue(params, this.getMandatoryCapabilityKey()))) {
            fieldErrors.put(this.getMandatoryCapabilityKey(), this.getText(this.getCapabilityUndefinedKey()));
        }
        return fieldErrors;
    }

    @Nullable
    public static String getParamValue(@NotNull Map<String, String[]> params, String field) {
        Object[] values = params.get(field);
        return ArrayUtils.isEmpty((Object[])values) ? null : ((String)values[0]).trim();
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String value = AbstractExecutableCapabilityTypeModule.getParamValue(params, this.getExecutableKey());
        return new CapabilityImpl(this.getMandatoryCapabilityKey(), value);
    }

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        ArrayList paths = Lists.newArrayList((Object[])StringUtils.split((String)SystemProperty.PATH.getValue(), (String)File.pathSeparator));
        if (SystemUtils.IS_OS_WINDOWS) {
            paths.addAll(this.getDefaultWindowPaths());
        }
        String executableName = SystemUtils.IS_OS_WINDOWS ? this.getExecutableFilename() + ".exe" : this.getExecutableFilename();
        for (String path : paths) {
            File file = new File(path, executableName);
            if (!file.exists()) continue;
            log.debug((Object)("Detected " + this.getMandatoryCapabilityKey() + " at `" + file.getAbsolutePath() + "'"));
            capabilitySet.addCapability((Capability)new CapabilityImpl(this.getMandatoryCapabilityKey(), file.getAbsolutePath()), false);
            return capabilitySet;
        }
        return capabilitySet;
    }

    @Deprecated
    protected TextProvider getTextProvider() {
        return this.textProvider.orElse(null);
    }

    public String getText(String key) {
        return this.getTextProvider().getText(key);
    }

    public String getText(String s, Object[] objects) {
        return this.getText(s, (String[])objects);
    }

    public String getText(String key, String[] args) {
        return this.getTextProvider().getText(key, args);
    }

    @Deprecated
    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = Optional.of(textProvider);
    }
}

