/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ExecutablePathUtils;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFileCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    private static final Logger log = Logger.getLogger(AbstractFileCapabilityDefaultsHelper.class);

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        File executable = ExecutablePathUtils.findExecutable((String)this.getExecutableName(), this.getValidityPredicate(), (String)this.getEnvHome(), this.getPosixHomes());
        if (executable != null) {
            Capability capability = this.createCapability(executable);
            if (capability != null) {
                capabilitySet.addCapability(capability);
            } else {
                log.error((Object)("Cannot create capability for " + executable));
            }
        }
        return capabilitySet;
    }

    @Nullable
    protected Capability createCapability(@NotNull File content) {
        return new CapabilityImpl(this.getCapabilityKey(), content.getAbsolutePath());
    }

    @NotNull
    protected abstract String getExecutableName();

    @NotNull
    protected abstract String getCapabilityKey();

    @Nullable
    protected String getEnvHome() {
        return null;
    }

    @NotNull
    protected List<String> getPosixHomes() {
        String posixHome = this.getPosixHome();
        return posixHome != null ? Collections.singletonList(posixHome) : Collections.emptyList();
    }

    @Deprecated
    @Nullable
    protected String getPosixHome() {
        return null;
    }

    @Nullable
    protected Predicate<File> getValidityPredicate() {
        return null;
    }
}

