/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractExecutableCapabilityTypeModule;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultipleExecutableCapabilityTypeModule
extends AbstractExecutableCapabilityTypeModule {
    public abstract String getExecutableKindKey();

    public abstract List<String> getAdditionalCapabilityKeys();

    public abstract String getCapabilityKindUndefinedKey();

    @Override
    @NotNull
    public String getLabel(@NotNull String key) {
        return this.getText("agent.capability.type." + key + ".type");
    }

    @Override
    public String getExecutableKey() {
        return "";
    }

    public Map<String, String> getExecutableTypes() {
        LinkedHashMap<String, String> executableTypes = new LinkedHashMap<String, String>();
        ArrayList capabilityKeys = Lists.newArrayList((Object[])new String[]{this.getMandatoryCapabilityKey()});
        capabilityKeys.addAll(this.getAdditionalCapabilityKeys());
        for (String key : capabilityKeys) {
            executableTypes.put(key, this.getLabel(key));
        }
        return executableTypes;
    }

    public String getExecutableDescription(String key) {
        return this.getText("agent.capability.type." + key + ".description");
    }

    @Override
    public String getValueDescriptionKey(@NotNull String key, @Nullable String value) {
        return this.getExecutableDescription(key);
    }

    @Override
    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String executableKind = AbstractMultipleExecutableCapabilityTypeModule.getParamValue(params, this.getExecutableKindKey());
        if (StringUtils.isEmpty((CharSequence)executableKind)) {
            fieldErrors.put(this.getExecutableKindKey(), this.getText(this.getCapabilityKindUndefinedKey()));
        } else {
            BambooFieldValidate.checkFieldXssSafety(fieldErrors, this.getTextProvider(), this.getExecutableKindKey(), executableKind);
            if (this.getMandatoryCapabilityKey().equals(executableKind) && StringUtils.isEmpty((CharSequence)AbstractMultipleExecutableCapabilityTypeModule.getParamValue(params, this.getMandatoryCapabilityKey()))) {
                fieldErrors.put(this.getMandatoryCapabilityKey(), this.getText(this.getCapabilityUndefinedKey()));
            }
        }
        return fieldErrors;
    }

    @Override
    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String key = AbstractMultipleExecutableCapabilityTypeModule.getParamValue(params, this.getExecutableKindKey());
        String value = AbstractMultipleExecutableCapabilityTypeModule.getParamValue(params, key);
        return new CapabilityImpl(key, value);
    }
}

