/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemotedCapabilitySetManager;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityContextImpl
implements CapabilityContext {
    private static final ThreadLocal<ReadOnlyCapabilitySet> threadLocal = new ThreadLocal();
    @Inject
    private RemotedCapabilitySetManager capabilitySetManager;

    @Nullable
    public ReadOnlyCapabilitySet getCapabilitySet() {
        ReadOnlyCapabilitySet threadCapabilitySet = threadLocal.get();
        return threadCapabilitySet != null ? threadCapabilitySet : this.capabilitySetManager.getSharedLocalCapabilitySet();
    }

    public void setCapabilitySet(@Nullable ReadOnlyCapabilitySet capabilitySet) {
        threadLocal.set(capabilitySet);
    }

    public void clearCapabilitySet() {
        threadLocal.remove();
    }

    @Nullable
    public String getCapabilityValue(@NotNull String key) {
        ReadOnlyCapabilitySet capabilities = this.getCapabilitySet();
        if (capabilities == null) {
            return null;
        }
        Capability capability = capabilities.getCapability(key);
        if (capability == null) {
            return null;
        }
        return capability.getValue();
    }
}

