/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.builder.JdkManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.perforce.PerforceManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.DefaultAgentCapabilityManager;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CapabilityDefaultsHelperImpl
implements CapabilityDefaultsHelper {
    private static final Logger log = Logger.getLogger(CapabilityDefaultsHelperImpl.class);
    private PerforceManager perforceManager;
    private JdkManager jdkManager;
    private DefaultAgentCapabilityManager defaultAgentCapabilityManager;
    private PluginAccessor pluginAccessor;

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySetParam) {
        final AtomicReference<CapabilitySet> capabilitySet = new AtomicReference<CapabilitySet>(capabilitySetParam);
        capabilitySet.set(this.jdkManager.addDefaultJdkToCapabilitySet(capabilitySet.get()));
        capabilitySet.set(this.perforceManager.addDefaultPerforceExe(capabilitySet.get()));
        capabilitySet.set(this.defaultAgentCapabilityManager.addDefaultCapabilitiesToCapabilitySet(capabilitySet.get()));
        List<CapabilityDefaultsHelper> modules = this.getCapabilityDefaultsHelpers();
        for (final CapabilityDefaultsHelper module : modules) {
            String errorMessage = "Module " + module.getClass().getName() + " error while detecting default capabilities: ";
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                @Override
                public void run() {
                    HashSet previousCapabilities = null;
                    if (log.isDebugEnabled()) {
                        previousCapabilities = Sets.newHashSet((Iterable)((CapabilitySet)capabilitySet.get()).getCapabilities());
                        log.debug((Object)("Adding default capability set for " + module.getClass().getName()));
                    }
                    CapabilitySet newCapabilities = module.addDefaultCapabilities((CapabilitySet)capabilitySet.get());
                    if (log.isDebugEnabled()) {
                        for (Capability capability : Sets.difference((Set)newCapabilities.getCapabilities(), (Set)previousCapabilities)) {
                            log.debug((Object)("Module " + module.getClass().getName() + " added capability " + capability));
                        }
                    }
                    capabilitySet.set(newCapabilities);
                }
            });
        }
        return capabilitySet.get();
    }

    private List<CapabilityDefaultsHelper> getCapabilityDefaultsHelpers() {
        ArrayList helpers = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModulesByClass(CapabilityDefaultsHelper.class));
        for (TaskModuleDescriptor taskModuleDescriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(TaskModuleDescriptor.class)) {
            CapabilityDefaultsHelper capabilityDefaultsHelper = taskModuleDescriptor.getCapabilityDefaultsHelper();
            if (capabilityDefaultsHelper == null) continue;
            helpers.add(capabilityDefaultsHelper);
        }
        return helpers;
    }

    public void setPerforceManager(PerforceManager perforceManager) {
        this.perforceManager = perforceManager;
    }

    public void setJdkManager(JdkManager jdkManager) {
        this.jdkManager = jdkManager;
    }

    public void setDefaultAgentCapabilityManager(DefaultAgentCapabilityManager defaultAgentCapabilityManager) {
        this.defaultAgentCapabilityManager = defaultAgentCapabilityManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

