/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="CAPABILITY")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class CapabilityImpl
extends BambooEntityObject
implements Capability {
    private static final Logger log = Logger.getLogger(CapabilityImpl.class);
    private volatile String key;
    private volatile String value;
    private volatile CapabilitySet capabilitySet;

    public CapabilityImpl() {
    }

    public CapabilityImpl(@NotNull String key, @Nullable String value) {
        this.setKey(key);
        this.setValue(value);
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public void setKey(@NotNull String key) {
        this.key = BambooInterners.intern((String)key);
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @NotNull
    public String getValueWithDefault() {
        return StringUtils.defaultString((String)this.value);
    }

    public void setValue(@Nullable String value) {
        this.value = BambooInterners.intern((String)value);
    }

    public CapabilitySet getCapabilitySet() {
        return this.capabilitySet;
    }

    public void setCapabilitySet(CapabilitySet capabilitySet) {
        this.capabilitySet = capabilitySet;
    }

    public void copyValueFrom(Capability other) {
        this.value = other.getValue();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getKey()).append((Object)StringUtils.defaultString((String)this.getValue())).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CapabilityImpl)) {
            return false;
        }
        CapabilityImpl rhs = (CapabilityImpl)((Object)o);
        return new EqualsBuilder().append((Object)this.getKey(), (Object)rhs.getKey()).append((Object)StringUtils.defaultString((String)this.getValue()), (Object)StringUtils.defaultString((String)rhs.getValue())).isEquals();
    }

    public int compareTo(Object obj) {
        CapabilityImpl o = (CapabilityImpl)((Object)obj);
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).append((Object)StringUtils.defaultString((String)this.getValue()), (Object)StringUtils.defaultString((String)o.getValue())).toComparison();
    }

    public String toString() {
        return this.key + " = " + this.value;
    }
}

