/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityMatchResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityRequirementsMatcherImpl
implements CapabilityRequirementsMatcher {
    private static final Logger log = Logger.getLogger(CapabilityRequirementsMatcherImpl.class);
    private final CacheLoader<String, Pattern> loader = new CacheLoader<String, Pattern>(){

        public Pattern load(String key) throws Exception {
            return Pattern.compile(key);
        }
    };
    private final LoadingCache<String, Pattern> patterns = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).build(this.loader);

    public boolean matches(@NotNull ReadOnlyCapabilitySet capabilities, Requirement requirement) {
        return this.matches(capabilities, (ImmutableRequirement)requirement);
    }

    public boolean matches(@NotNull ReadOnlyCapabilitySet capabilities, ImmutableRequirement requirement) {
        if (requirement == null) {
            return true;
        }
        Capability capability = capabilities.getCapability(requirement.getKey());
        return capability != null && this.singleMatch(capability, requirement);
    }

    public boolean matches(@NotNull ReadOnlyCapabilitySet capabilities, MinimalRequirementSet requirements) {
        return this.matches(capabilities, (ImmutableRequirementSet)requirements);
    }

    public boolean matches(@NotNull ReadOnlyCapabilitySet capabilities, ImmutableRequirementSet requirements) {
        if (requirements == null || requirements.getRequirements().isEmpty()) {
            return true;
        }
        for (ImmutableRequirement requirement : requirements.getRequirements()) {
            if (this.isRequirementMet(capabilities, requirement)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public CapabilityMatchResult matchesWithResult(@NotNull ReadOnlyCapabilitySet capabilities, @Nullable ImmutableRequirementSet requirements) {
        if (requirements == null || requirements.getRequirements().isEmpty()) {
            return CapabilityMatchResult.MATCHES;
        }
        ArrayList<ImmutableRequirement> unmetRequirements = new ArrayList<ImmutableRequirement>();
        for (ImmutableRequirement requirement : requirements.getRequirements()) {
            boolean isRequirementMet = this.isRequirementMet(capabilities, requirement);
            if (isRequirementMet) continue;
            unmetRequirements.add(requirement);
        }
        return new CapabilityMatchResult(unmetRequirements.isEmpty(), unmetRequirements);
    }

    @NotNull
    public CapabilityMatchResult matchesWithResult(@NotNull ReadOnlyCapabilitySet capabilities, MinimalRequirementSet requirements) {
        return this.matchesWithResult(capabilities, (ImmutableRequirementSet)requirements);
    }

    private boolean isRequirementMet(@NotNull ReadOnlyCapabilitySet capabilities, @NotNull ImmutableRequirement requirement) {
        Capability capability = capabilities.getCapability(requirement.getKey());
        return capability != null && this.singleMatch(capability, requirement);
    }

    private boolean singleMatch(Capability capability, ImmutableRequirement requirement) {
        if (!capability.getKey().equals(requirement.getKey())) {
            return false;
        }
        String matchValue = requirement.getMatchValue();
        assert (matchValue != null);
        if (!requirement.isRegexMatch()) {
            return matchValue.equals(capability.getValueWithDefault());
        }
        if (matchValue.equals(".*")) {
            return true;
        }
        Pattern pattern = (Pattern)this.patterns.getUnchecked((Object)matchValue);
        Matcher matcher = pattern.matcher(capability.getValueWithDefault());
        return matcher.matches();
    }
}

