/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeType;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeTypes;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.concurrent.TransientResettableLazyReference;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="CAPABILITY_SET")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@NotThreadSafe
public class CapabilitySetImpl
extends BambooEntityObject
implements CapabilitySet {
    private static final Logger log = Logger.getLogger(CapabilitySetImpl.class);
    @WhitelistAssumeRuntimeTypes(value={@WhitelistAssumeRuntimeType(value=FinalHashSet.class), @WhitelistAssumeRuntimeType(value=CapabilityImpl.class)})
    private Set<Capability> capabilities;
    private CapabilityScope capabilityScope;
    private final CapabilitiesByKeys capabilitiesByKeys = new CapabilitiesByKeys(this);

    public CapabilitySetImpl() {
    }

    public CapabilitySetImpl(CapabilityScope capabilityScope, Capability ... capabilities) {
        this(capabilityScope);
        this.capabilities = new FinalHashSet((Object[])capabilities);
    }

    public CapabilitySetImpl(CapabilityScope capabilityScope) {
        this.capabilityScope = capabilityScope;
    }

    @Nullable
    public Capability getCapability(@NotNull String key) {
        if (this.capabilities == null) {
            return null;
        }
        return (Capability)((Map)this.capabilitiesByKeys.get()).get(key);
    }

    @NotNull
    public Set<Capability> getCapabilities() {
        if (this.capabilities == null) {
            return new FinalHashSet();
        }
        return this.capabilities;
    }

    public void addCapability(@NotNull Capability capability) {
        this.addCapability(capability, true);
    }

    public void addCapability(@NotNull Capability capability, boolean overwrite) {
        if (this.capabilities == null) {
            this.capabilities = new FinalHashSet();
        }
        String key = capability.getKey();
        Capability existingCapability = this.getCapability(key);
        if (this.getCapability(key) != null) {
            if (overwrite) {
                existingCapability.copyValueFrom(capability);
            } else {
                log.debug((Object)("Capability '" + capability + "' not added since key already exists."));
            }
        } else {
            capability.setCapabilitySet((CapabilitySet)this);
            this.capabilities.add(capability);
        }
        this.capabilitiesByKeys.reset();
    }

    public void removeCapability(@NotNull String key) {
        if (this.capabilities == null) {
            return;
        }
        Iterator<Capability> capabilityIterator = this.capabilities.iterator();
        while (capabilityIterator.hasNext()) {
            Capability capability = capabilityIterator.next();
            if (!capability.getKey().equals(key)) continue;
            capability.setCapabilitySet(null);
            capabilityIterator.remove();
        }
        this.capabilitiesByKeys.reset();
    }

    @NotNull
    public CapabilityScope getCapabilityScope() {
        return this.capabilityScope;
    }

    @Nullable
    public String getSharedCapabilitySetType() {
        return null;
    }

    public String getCapabilitySetType() {
        return null;
    }

    public void setCapabilities(Set<Capability> capabilities) {
        this.capabilities = capabilities;
        this.capabilitiesByKeys.reset();
    }

    public void setCapabilityScope(CapabilityScope capabilityScope) {
        this.capabilityScope = capabilityScope;
    }

    public int hashCode() {
        return new HashCodeBuilder(9, 7).append((Object)this.getCapabilityScope()).append(this.getCapabilities()).append((Object)this.getCapabilitySetType()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CapabilitySetImpl)) {
            return false;
        }
        CapabilitySetImpl rhs = (CapabilitySetImpl)((Object)o);
        return new EqualsBuilder().append((Object)this.getCapabilityScope(), (Object)rhs.getCapabilityScope()).append(this.getCapabilities(), rhs.getCapabilities()).append((Object)this.getCapabilitySetType(), (Object)rhs.getCapabilitySetType()).isEquals();
    }

    public int compareTo(Object obj) {
        CapabilitySetImpl o = (CapabilitySetImpl)((Object)obj);
        return new CompareToBuilder().append((Object)this.getCapabilityScope(), (Object)o.getCapabilityScope()).append(this.getCapabilities(), o.getCapabilities()).append((Object)this.getCapabilitySetType(), (Object)o.getCapabilitySetType()).toComparison();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{capabilities=" + this.capabilities + ", capabilityScope=" + this.capabilityScope + '}';
    }

    private static final class CapabilitiesByKeys
    extends TransientResettableLazyReference<Map<String, Capability>> {
        private final CapabilitySetImpl capabilitySet;

        private CapabilitiesByKeys(CapabilitySetImpl capabilitySet) {
            this.capabilitySet = capabilitySet;
        }

        protected Map<String, Capability> create() {
            return (Map)this.capabilitySet.capabilities.stream().collect(BambooCollectors.toMap(Capability::getKey));
        }
    }
}

