/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.dao.AgentDao;
import com.atlassian.bamboo.capability.CapabilitySetProvider;
import com.atlassian.bamboo.capability.ImageCapabilitySetDao;
import com.atlassian.bamboo.capability.LocalCapabilitySetDao;
import com.atlassian.bamboo.capability.RemoteCapabilitySetDao;
import com.atlassian.bamboo.event.AllAgentsUpdatedEvent;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManagerUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CombinedReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemoteCapabilitySet;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class CapabilitySetManagerImpl
implements CapabilitySetManager {
    @Lazy
    @Inject
    private LocalCapabilitySetDao localCapabilityDao;
    @Lazy
    @Inject
    private RemoteCapabilitySetDao remoteCapabilityDao;
    @Lazy
    @Inject
    private ImageCapabilitySetDao imageCapabilityDao;
    @Lazy
    @Inject
    private AgentDao agentDao;
    @Lazy
    @Inject
    private EventPublisher eventPublisher;

    @Nullable
    public CapabilitySet getSharedLocalCapabilitySet() {
        return (CapabilitySet)ThreadScopedCaches.getValue((ThreadScopedCaches.Key)RequestScopedCacheKey.CAPABILITY_SETS, (Object)"sharedLocalCapabilitySet", () -> this.localCapabilityDao.getSharedCapabilitySet());
    }

    public CapabilitySet getSharedRemoteCapabilitySet() {
        return (CapabilitySet)ThreadScopedCaches.getValue((ThreadScopedCaches.Key)RequestScopedCacheKey.CAPABILITY_SETS, (Object)"sharedRemoteCapabilitySet", () -> this.remoteCapabilityDao.getSharedCapabilitySet());
    }

    @Nullable
    public CapabilitySet getSharedCapabilitySet(@NotNull CapabilitySet agentCapabilitySet) {
        return CapabilitySetManagerUtils.getSharedCapabilitySet(this, agentCapabilitySet.getClass());
    }

    @Nullable
    public PipelineDefinition getPipelineDefinition(@NotNull CapabilitySet capabilitySet) {
        return this.localCapabilityDao.getPipelineDefinition(capabilitySet);
    }

    @Nullable
    public ElasticImageConfiguration getElasticImage(@NotNull CapabilitySet capabilitySet) {
        return this.localCapabilityDao.getElasticImageConfiguration(capabilitySet);
    }

    @NotNull
    public ReadOnlyCapabilitySet getCombinedCapabilitySet(@NotNull CapabilitySet agentCapabilitySet) {
        CapabilitySet sharedCapabilitySet = CapabilitySetManagerUtils.getSharedCapabilitySet(this, agentCapabilitySet.getClass());
        return this.getCombinedCapabilitySet(agentCapabilitySet, sharedCapabilitySet);
    }

    public ReadOnlyCapabilitySet getCombinedCapabilitySet(@NotNull CapabilitySet agentCapabilitySet, @Nullable CapabilitySet sharedCapabilitySet) {
        if (sharedCapabilitySet == null) {
            return agentCapabilitySet;
        }
        return new CombinedReadOnlyCapabilitySet(agentCapabilitySet, sharedCapabilitySet);
    }

    @Nullable
    public ReadOnlyCapabilitySet getCombinedCapabilitySet(long agentId) {
        PipelineDefinition pipelineDefinition = this.agentDao.getAgentById(agentId);
        if (pipelineDefinition == null) {
            return null;
        }
        CapabilitySet agentCapabilitySet = CapabilitySetProvider.getAgentCapabilitySet(pipelineDefinition);
        return this.getCombinedCapabilitySet(agentCapabilitySet);
    }

    @NotNull
    public CapabilitySet createAgentCapabilitySet(@NotNull LocalAgentDefinition pipelineDefinition) {
        LocalCapabilitySet capabilitySet = new LocalCapabilitySet(CapabilityScope.AGENT);
        pipelineDefinition.setCapabilitySet((CapabilitySet)capabilitySet);
        return capabilitySet;
    }

    @NotNull
    public CapabilitySet createAgentCapabilitySet(@NotNull RemoteAgentDefinition pipelineDefinition) {
        RemoteCapabilitySet capabilitySet = new RemoteCapabilitySet(CapabilityScope.AGENT);
        pipelineDefinition.setCapabilitySet((CapabilitySet)capabilitySet);
        return capabilitySet;
    }

    public void saveCapabilitySet(@NotNull CapabilitySet capabilitySet) {
        if (capabilitySet instanceof RemoteCapabilitySet) {
            this.remoteCapabilityDao.saveCapabilitySet(capabilitySet);
        } else if (capabilitySet instanceof LocalCapabilitySet) {
            this.localCapabilityDao.saveCapabilitySet(capabilitySet);
        } else if (capabilitySet instanceof ImageCapabilitySet) {
            this.imageCapabilityDao.saveCapabilitySet(capabilitySet);
        } else {
            throw new IllegalArgumentException("Capability Manager can not recognise type of capability set to be saved.");
        }
        this.eventPublisher.publish((Object)new AllAgentsUpdatedEvent(this));
    }

    @NotNull
    public Collection<String> getSystemCapabilityKeys(@NotNull String type, boolean isElasticEnabled) {
        return isElasticEnabled ? this.localCapabilityDao.getAllSystemKeysByType(type) : this.localCapabilityDao.getSystemKeysExcludingElasticByType(type);
    }

    @NotNull
    public Collection<Capability> getSystemCapabilities(@NotNull String type) {
        return this.localCapabilityDao.getSystemCapabilities(type);
    }

    @NotNull
    public Collection<Capability> getSystemCapabilitiesByKey(@NotNull String key) {
        return this.localCapabilityDao.getSystemCapabilitiesByKey(key);
    }

    @NotNull
    public List<String> findUniqueCapabilityKeys() {
        return this.localCapabilityDao.findUniqueCapabilityKeys();
    }

    private static enum RequestScopedCacheKey implements ThreadScopedCaches.Key<String, CapabilitySet>
    {
        CAPABILITY_SETS;

    }
}

