/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedReadOnlyCapabilitySet
implements ReadOnlyCapabilitySet {
    private static final Logger log = Logger.getLogger(CombinedReadOnlyCapabilitySet.class);
    Set<Capability> capabilities;

    public CombinedReadOnlyCapabilitySet(@NotNull CapabilitySet agentCapabilitySet, @NotNull CapabilitySet sharedCapabilitySet) {
        if (!CapabilityScope.AGENT.equals((Object)agentCapabilitySet.getCapabilityScope())) {
            throw new IllegalArgumentException("Cannot combine capability set which is not agent scope");
        }
        if (!CapabilityScope.SHARED.equals((Object)sharedCapabilitySet.getCapabilityScope())) {
            throw new IllegalArgumentException("Cannot combine capability set which is not shared scope");
        }
        this.capabilities = new HashSet<Capability>();
        for (Capability capability : sharedCapabilitySet.getCapabilities()) {
            if (agentCapabilitySet.getCapability(capability.getKey()) != null) continue;
            this.capabilities.add(capability);
        }
        this.capabilities.addAll(agentCapabilitySet.getCapabilities());
    }

    @Nullable
    public Capability getCapability(@NotNull String key) {
        if (this.capabilities == null) {
            return null;
        }
        for (Capability capability : this.capabilities) {
            if (!capability.getKey().equals(key)) continue;
            return capability;
        }
        return null;
    }

    @NotNull
    public Set<Capability> getCapabilities() {
        if (this.capabilities == null) {
            return Collections.emptySet();
        }
        return this.capabilities;
    }
}

