/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.utils.CommonsConfigUtils;
import com.atlassian.bamboo.utils.ResourceResolver;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.DefaultAgentCapabilityManager;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class DefaultAgentCapabilityManagerImpl
implements DefaultAgentCapabilityManager {
    private static final Logger log = Logger.getLogger(DefaultAgentCapabilityManagerImpl.class);
    private static final String BAMBOO_CAPABILITIES_PROPERTY_FILE = "bamboo-capabilities.properties";
    private final PropertiesConfiguration configuration;

    public DefaultAgentCapabilityManagerImpl(ResourceResolver resourceResolver) {
        this(BAMBOO_CAPABILITIES_PROPERTY_FILE, resourceResolver);
    }

    public DefaultAgentCapabilityManagerImpl(String propertyFilename, ResourceResolver resourceResolver) {
        PropertiesConfiguration config;
        try {
            config = new PropertiesConfiguration(resourceResolver.findResource(propertyFilename));
            log.info((Object)("Default agent capabilities loaded from " + propertyFilename));
        }
        catch (ConfigurationException e) {
            log.info((Object)("Failed to load " + propertyFilename));
            log.debug((Object)e.getMessage(), (Throwable)e);
            config = null;
        }
        this.configuration = config;
    }

    @Override
    public CapabilitySet addDefaultCapabilitiesToCapabilitySet(CapabilitySet capabilitySet) {
        if (this.configuration == null) {
            return capabilitySet;
        }
        for (String key : CommonsConfigUtils.getKeys((PropertiesConfiguration)this.configuration)) {
            String value = this.configuration.getString(key);
            log.debug((Object)("Adding default capability key:" + key + " value: " + value));
            capabilitySet.addCapability((Capability)new CapabilityImpl(key, value), false);
        }
        return capabilitySet;
    }

    @Override
    public CapabilitySet updateChangedCapabilitiesToCapabilitySet(CapabilitySet capabilitySet) {
        if (this.configuration == null) {
            return capabilitySet;
        }
        for (String key : CommonsConfigUtils.getKeys((PropertiesConfiguration)this.configuration)) {
            String value = this.configuration.getString(key);
            Capability oldValue = capabilitySet.getCapability(key);
            if (oldValue == null) continue;
            log.info((Object)("Updating default capability key:" + key + " new value: " + value + " old value: " + oldValue));
            capabilitySet.addCapability((Capability)new CapabilityImpl(key, value), true);
        }
        return capabilitySet;
    }

    @Override
    public boolean isDefaultConfigurationAvailable() {
        return this.configuration != null && !this.configuration.isEmpty();
    }
}

